/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.actors.Debug$;
import scala.actors.remote.Node;
import scala.actors.remote.TcpService;

public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private boolean running;
    private Node connectedNode;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private OutputStream out;
    private InputStream in;
    private Socket so;
    private TcpService parent;

    public TcpServiceWorker(TcpService parent, Socket so) {
        this.parent = parent;
        this.so = so;
        this.in = so.getInputStream();
        this.out = so.getOutputStream();
        this.datain = new DataInputStream(this.in());
        this.dataout = new DataOutputStream(this.out());
        this.running = true;
    }

    public void run() {
        try {
            while (this.running()) {
                Object msg = this.parent.serializer().readObject(this.datain());
                this.parent.kernel().processMsg(this.connectedNode(), msg);
            }
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + exception);
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + iOException);
            this.parent.nodeDown(this.connectedNode());
        }
        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
    }

    public void halt() {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void transmit(byte[] data) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": transmitting data..."));
            this.dataout().writeInt(data.length);
            this.dataout().write(data);
            this.dataout().flush();
            return;
        }
    }

    public void readNode() {
        Object node = this.parent.serializer().readObject(this.datain());
        Object object = node;
        if (object instanceof Node) {
            Node node2;
            Node n = node2 = (Node)object;
            this.connectedNode_$eq(n);
            this.parent.addConnection(n, this);
            return;
        }
        throw new MatchError(object);
    }

    public void sendNode(Node n) {
        this.connectedNode_$eq(n);
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void connectedNode_$eq(Node x$1) {
        this.connectedNode = x$1;
    }

    public Node connectedNode() {
        return this.connectedNode;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public DataInputStream datain() {
        return this.datain;
    }

    public OutputStream out() {
        return this.out;
    }

    public InputStream in() {
        return this.in;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

