/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalap;

import scala.ScalaObject;

public class ByteArrayReader
implements ScalaObject {
    private int bp;
    private byte[] buf;

    public ByteArrayReader(byte[] byArray) {
        this.buf = byArray;
        this.bp = 0;
    }

    public void skip(int n) {
        this.bp_$eq(this.bp() + n);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    public float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public long getLong(int n) {
        return ((long)this.getInt(n) << 32) + ((long)this.getInt(n + 4) & 0xFFFFFFFFL);
    }

    public int getInt(int n) {
        return ((this.buf()[n] & 0xFF) << 24) + ((this.buf()[n + 1] & 0xFF) << 16) + ((this.buf()[n + 2] & 0xFF) << 8) + (this.buf()[n + 3] & 0xFF);
    }

    public char getChar(int n) {
        return (char)(((this.buf()[n] & 0xFF) << 8) + (this.buf()[n + 1] & 0xFF));
    }

    public String nextUTF8(int n) {
        char[] cArray = new char[n];
        int n2 = this.bp();
        int n3 = 0;
        this.bp_$eq(this.bp() + n);
        while (n2 < this.bp()) {
            int n4 = this.buf()[n2] & 0xFF;
            ++n2;
            if (n4 < 224) {
                if (n4 >= 192) {
                    n4 = (n4 & 0x1F) << 6 | this.buf()[n2] & 0x3F;
                    ++n2;
                }
            } else {
                n4 = (n4 & 0xF) << 12 | (this.buf()[n2] & 0x3F) << 6;
                n4 |= this.buf()[++n2] & 0x3F;
                ++n2;
            }
            cArray[n3] = (char)n4;
            ++n3;
        }
        return new String(cArray, 0, n3);
    }

    public long nextNum(int n) {
        long l = 0L;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                int n3 = 64 - n * 8;
                return l << n3 >> n3;
            }
            l = (l << 8) + (long)(this.nextByte() & 0xFF);
            ++n2;
        }
    }

    public int nextNat() {
        int n = 0;
        int n2 = 0;
        do {
            n2 = this.buf()[this.bp()];
            this.bp_$eq(this.bp() + 1);
            n = (n << 7) + (n2 & 0x7F);
        } while ((n2 & 0x80) != 0);
        return n;
    }

    public double nextDouble() {
        return Double.longBitsToDouble(this.nextLong());
    }

    public float nextFloat() {
        return Float.intBitsToFloat(this.nextInt());
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + ((long)this.nextInt() & 0xFFFFFFFFL);
    }

    public int nextInt() {
        this.bp_$eq(this.bp() + 4);
        return ((this.buf()[this.bp() - 4] & 0xFF) << 24) + ((this.buf()[this.bp() - 3] & 0xFF) << 16) + ((this.buf()[this.bp() - 2] & 0xFF) << 8) + (this.buf()[this.bp() - 1] & 0xFF);
    }

    public char nextChar() {
        this.bp_$eq(this.bp() + 2);
        return (char)(((this.buf()[this.bp() - 2] & 0xFF) << 8) + (this.buf()[this.bp() - 1] & 0xFF));
    }

    public byte[] nextBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf(), this.bp(), byArray, 0, n);
        this.bp_$eq(this.bp() + n);
        return byArray;
    }

    public byte nextByte() {
        this.bp_$eq(this.bp() + 1);
        return this.buf()[this.bp() - 1];
    }

    public byte byteAt(int n) {
        return this.buf()[n];
    }

    public void bp_$eq(int n) {
        this.bp = n;
    }

    public int bp() {
        return this.bp;
    }

    public byte[] buf() {
        return this.buf;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

