/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalap;

import java.io.Writer;
import scala.Predef$;
import scala.ScalaObject;
import scala.runtime.BoxedByte;
import scala.runtime.BoxedShort;

public class CodeWriter
implements ScalaObject {
    private boolean line;
    private boolean space;
    private boolean align;
    private int level;
    private String step;
    private String nl;
    private Writer writer;

    public CodeWriter(Writer writer) {
        this.writer = writer;
        this.nl = System.getProperty("line.separator");
        this.step = "  ";
        this.level = 0;
        this.align = false;
        this.space = false;
        this.line = false;
    }

    public String toString() {
        return this.writer.toString();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeWriter print(String string) {
        try {
            boolean bl = true;
            while (true) {
                int n;
                block9: {
                    block8: {
                        block7: {
                            if (!bl || (bl = false)) break block7;
                            if (!this.align()) break block8;
                            n = 0;
                        }
                        if (n < this.level()) break block9;
                    }
                    if (this.space()) {
                        this.writer.write(" ");
                    }
                    this.writer.write(string);
                    this.align_$eq(false);
                    this.space_$eq(false);
                    this.line_$eq(false);
                    return this;
                }
                this.writer.write(this.step());
                ++n;
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.error("IO error");
            return null;
        }
    }

    public CodeWriter print(double d) {
        return this.print(String.valueOf(d));
    }

    public CodeWriter print(float f) {
        return this.print(String.valueOf(f));
    }

    public CodeWriter print(long l) {
        return this.print(String.valueOf(l));
    }

    public CodeWriter print(int n) {
        return this.print(String.valueOf(n));
    }

    public CodeWriter print(char c) {
        return this.print(String.valueOf(c));
    }

    public CodeWriter print(short s) {
        return this.print(String.valueOf(BoxedShort.box((short)s)));
    }

    public CodeWriter print(byte by) {
        return this.print(String.valueOf(BoxedByte.box((byte)by)));
    }

    public CodeWriter print(boolean bl) {
        return this.print(String.valueOf(bl));
    }

    public CodeWriter println(String string) {
        return this.print(string).newline();
    }

    public CodeWriter println(double d) {
        return this.print(d).newline();
    }

    public CodeWriter println(float f) {
        return this.print(f).newline();
    }

    public CodeWriter println(long l) {
        return this.print(l).newline();
    }

    public CodeWriter println(int n) {
        return this.print(n).newline();
    }

    public CodeWriter println(char c) {
        return this.print(c).newline();
    }

    public CodeWriter println(short s) {
        return this.print(s).newline();
    }

    public CodeWriter println(byte by) {
        return this.print(by).newline();
    }

    public CodeWriter println(boolean bl) {
        return this.print(bl).newline();
    }

    public CodeWriter println() {
        return this.newline();
    }

    public void $times() {
    }

    public CodeWriter newspace() {
        this.space_$eq(!this.align());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeWriter newline() {
        CodeWriter codeWriter;
        String string = this.step();
        if (string != null && !string.equals(null)) {
            if (this.line()) {
                codeWriter = this;
                return codeWriter;
            }
            try {
                this.writer.write(this.nl());
                this.line_$eq(this.align());
                this.align_$eq(true);
                this.space_$eq(false);
                codeWriter = this;
                return codeWriter;
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.error("IO error");
                return null;
            }
        }
        codeWriter = this.newspace();
        return codeWriter;
    }

    public CodeWriter undent() {
        this.level_$eq(this.level() - 1);
        return this;
    }

    public CodeWriter indent() {
        this.level_$eq(this.level() + 1);
        return this;
    }

    public CodeWriter setIndentString(String string) {
        this.step_$eq(string);
        return this;
    }

    public String getIndentString() {
        return this.step();
    }

    public CodeWriter setIndentWidth(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
        }
        return this.setIndentString(stringBuffer.toString());
    }

    public int getIndentWidth() {
        String string = this.step();
        return string != null && !string.equals(null) ? this.step().length() : -1;
    }

    public CodeWriter setIndentLevel(int n) {
        this.level_$eq(n);
        return this;
    }

    public int getIndentLevel() {
        return this.level();
    }

    public Writer getWriter() {
        return this.writer;
    }

    private void line_$eq(boolean bl) {
        this.line = bl;
    }

    private boolean line() {
        return this.line;
    }

    private void space_$eq(boolean bl) {
        this.space = bl;
    }

    private boolean space() {
        return this.space;
    }

    private void align_$eq(boolean bl) {
        this.align = bl;
    }

    private boolean align() {
        return this.align;
    }

    private void level_$eq(int n) {
        this.level = n;
    }

    private int level() {
        return this.level;
    }

    private void step_$eq(String string) {
        this.step = string;
    }

    private String step() {
        return this.step;
    }

    private String nl() {
        return this.nl;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

