/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExactNumeric<Type>
extends Numeric<Type>
implements ScalaObject {
    private final int nativeTypeId;

    public ExactNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    @Override
    public String sqlString() {
        block11: {
            block12: {
                String string;
                int tp1 = this.precisionRadix();
                int tp2 = this.precision();
                int tp3 = this.scale();
                switch (tp1) {
                    default: {
                        throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
                    }
                    case 10: {
                        if (tp3 == 0) {
                            string = new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp2)).toString()).append((Object)")").toString();
                            break;
                        }
                        string = new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp2)).toString()).append((Object)", ").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp3)).toString()).append((Object)")").toString();
                        break;
                    }
                    case 2: {
                        if (tp2 == 16) {
                            if (tp3 == 0) {
                                string = "SMALLINT";
                                break;
                            }
                            throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                        }
                        if (tp2 == 32) {
                            if (tp3 == 0) {
                                string = "INTEGER";
                                break;
                            }
                            throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                        }
                        if (tp2 == 64) {
                            if (tp3 == 0) {
                                string = "BIGINT";
                                break;
                            }
                            throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                        }
                        if (tp2 != Integer.MAX_VALUE) break block11;
                        if (tp3 != 0) break block12;
                        string = "BIGINT";
                    }
                }
                return string;
            }
            throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
        }
        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
    }

    public abstract int scale();

    @Override
    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        if (datatype instanceof ExactNumeric) {
            ExactNumeric temp4 = (ExactNumeric)datatype;
            bl = this.nativeTypeId() == temp4.nativeTypeId() && this.precisionRadix() == temp4.precisionRadix() && this.precision() <= temp4.precision() && this.scale() <= temp4.scale() && this.signed() == temp4.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        if (datatype instanceof ExactNumeric) {
            ExactNumeric temp2 = (ExactNumeric)datatype;
            bl = this.nativeTypeId() == temp2.nativeTypeId() && this.precisionRadix() == temp2.precisionRadix() && this.precision() == temp2.precision() && this.scale() == temp2.scale() && this.signed() == temp2.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

