/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedNumber;

public abstract class ApproximateNumeric
extends Numeric
implements ScalaObject {
    private int nativeTypeId;

    public ApproximateNumeric(int n) {
        this.nativeTypeId = n;
        super(n);
    }

    public String sqlString() {
        Tuple2 tuple2 = new Tuple2((Object)BoxedInt.box((int)this.precisionRadix()), (Object)BoxedInt.box((int)this.precision()));
        if (tuple2 != null) {
            String string;
            Tuple2 tuple22 = tuple2;
            Object object = tuple22._1();
            if ((object == null ? 0 : ((BoxedNumber)object).intValue()) != 2) {
                Object object2 = tuple22._1();
                if ((object2 == null ? 0 : ((BoxedNumber)object2).intValue()) != 10) {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
                }
                string = "FLOAT (" + tuple22._2().toString() + ")";
            } else {
                Object object3 = tuple22._2();
                if ((object3 == null ? 0 : ((BoxedNumber)object3).intValue()) != 64) {
                    Object object4 = tuple22._2();
                    if ((object4 == null ? 0 : ((BoxedNumber)object4).intValue()) != 128) {
                        throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    string = "DOUBLE PRECISION";
                } else {
                    string = "REAL";
                }
            }
            return string;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean isSubtypeOf(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof ApproximateNumeric)) {
            bl = false;
        } else {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric approximateNumeric2 = approximateNumeric = (ApproximateNumeric)dataType2;
            bl = this.nativeTypeId() == approximateNumeric2.nativeTypeId() && this.precisionRadix() == approximateNumeric2.precisionRadix() && this.precision() <= approximateNumeric2.precision() && this.signed() == approximateNumeric2.signed();
        }
        return bl;
    }

    public boolean isEquivalent(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof ApproximateNumeric)) {
            bl = false;
        } else {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric approximateNumeric2 = approximateNumeric = (ApproximateNumeric)dataType2;
            bl = this.nativeTypeId() == approximateNumeric2.nativeTypeId() && this.precisionRadix() == approximateNumeric2.precisionRadix() && this.precision() == approximateNumeric2.precision() && this.signed() == approximateNumeric2.signed();
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

