/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JMember;
import ch.epfl.lamp.fjbg.JType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class JFieldOrMethod
extends JMember {
    protected final JClass owner;
    protected final JType type;
    protected final int nameIndex;
    protected final int signatureIndex;

    protected JFieldOrMethod(FJBGContext context2, JClass owner, int accessFlags, String name, JType type) {
        super(context2, accessFlags, name);
        this.owner = owner;
        this.type = type;
        this.nameIndex = owner.pool.addUtf8(name);
        this.signatureIndex = owner.pool.addUtf8(type.getSignature());
    }

    protected JFieldOrMethod(FJBGContext context2, JClass owner, DataInputStream stream) throws IOException {
        super(context2);
        this.owner = owner;
        this.accessFlags = stream.readShort();
        this.nameIndex = stream.readShort();
        this.name = owner.pool.lookupUtf8(this.nameIndex);
        this.signatureIndex = stream.readShort();
        this.type = JType.parseSignature(owner.pool.lookupUtf8(this.signatureIndex));
        this.attributes.addAll(JAttribute.readFrom(context2, owner, this, stream));
    }

    public void freeze() throws JCode.OffsetTooBigException {
        assert (!this.frozen);
        this.frozen = true;
    }

    public JClass getOwner() {
        return this.owner;
    }

    public JType getType() {
        return this.type;
    }

    public JClass getJClass() {
        return this.owner;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isSuper() {
        return (this.accessFlags & 0x20) != 0;
    }

    public boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isStrict() {
        return (this.accessFlags & 0x800) != 0;
    }

    public boolean isBridge() {
        return (this.accessFlags & 0x40) != 0;
    }

    public boolean hasVarargs() {
        return (this.accessFlags & 0x80) != 0;
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        if (!this.frozen) {
            try {
                this.freeze();
            }
            catch (JCode.OffsetTooBigException e) {
                throw new Error(e);
            }
        }
        stream.writeShort(this.accessFlags);
        stream.writeShort(this.nameIndex);
        stream.writeShort(this.signatureIndex);
        JAttribute.writeTo(this.getAttributes(), stream);
    }
}

