/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.io.ZipArchive;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.NoPosition$;

public class SourceReader
implements ScalaObject {
    private CharBuffer chars;
    private final ByteBuffer bytes;
    private final Reporter reporter;
    private final CharsetDecoder decoder;

    public static final CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static final CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public char[] read(ByteBuffer bytes2) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes2, chars, true)));
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes2 = this.bytes();
        bytes2.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes2) < 0;
            bytes2.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes2, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(AbstractFile file) {
        char[] cArray;
        if (file instanceof PlainFile) {
            PlainFile temp2 = (PlainFile)file;
            cArray = this.read(temp2.file());
        } else if (file instanceof ZipArchive.FileEntry) {
            ZipArchive.FileEntry temp3 = (ZipArchive.FileEntry)file;
            ReadableByteChannel c = Channels.newChannel(temp3.getArchive().getInputStream(temp3.entry));
            cArray = this.read(c);
        } else {
            char[] exceptionResult2;
            ByteBuffer b = ByteBuffer.wrap(file.toByteArray());
            try {
                exceptionResult2 = this.read(b);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.reportEncodingError(file.toString());
                exceptionResult2 = new char[]{};
            }
            cArray = exceptionResult2;
        }
        return cArray;
    }

    public char[] read(File file) {
        char[] exceptionResult1;
        FileChannel c = new FileInputStream(file).getChannel();
        try {
            exceptionResult1 = this.read(c);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.reportEncodingError(file.toString());
            exceptionResult1 = new char[]{};
            return exceptionResult1;
        }
        return exceptionResult1;
        finally {
            c.close();
        }
    }

    public char[] read(String filename) {
        return this.read(new File(filename));
    }

    private void reportEncodingError(String filename) {
        this.reporter.error(NoPosition$.MODULE$, new StringBuilder().append((Object)"IO error while decoding ").append((Object)filename).append((Object)" with ").append((Object)this.decoder.charset()).append((Object)"\n").append((Object)"Please try specifying another one using the -encoding option").toString());
    }

    private void chars_$eq(CharBuffer charBuffer) {
        this.chars = charBuffer;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }
}

