/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.doc.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.tools.nsc.doc.Settings;
import scala.tools.nsc.doc.html.HtmlFactory$;
import scala.tools.nsc.doc.html.page.Index;
import scala.tools.nsc.doc.html.page.Template;
import scala.tools.nsc.doc.model.DocTemplateEntity;
import scala.tools.nsc.doc.model.Package;
import scala.tools.nsc.reporters.Reporter;

public class HtmlFactory
implements ScalaObject {
    private final Settings settings;
    private final Reporter reporter;

    public HtmlFactory(Reporter reporter, Settings settings) {
        this.reporter = reporter;
        this.settings = settings;
    }

    public final void writeTemplate$1(DocTemplateEntity tpl, HashSet hashSet) {
        new Template(tpl).writeFor(this);
        hashSet.$plus$eq((Object)tpl);
        ((TraversableLike)tpl.templates().filter((Function1)new $anonfun$writeTemplate$1$1(this, hashSet))).map((Function1)new $anonfun$writeTemplate$1$2(this, hashSet), List$.MODULE$.canBuildFrom());
    }

    private final void copyResource$1(String subPath) {
        byte[] buf = new byte[1024];
        InputStream in = this.getClass().getResourceAsStream(new StringBuilder().append((Object)"/scala/tools/nsc/doc/html/resource/").append((Object)subPath).toString());
        Predef$.MODULE$.assert(in != null && !in.equals(null));
        File dest = new File(this.siteRoot(), subPath);
        dest.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(dest);
        try {
            int len;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            return;
        }
        finally {
            in.close();
            out.close();
        }
    }

    public void generate(Package modelRoot) {
        this.copyResource$1("lib/jquery.js");
        this.copyResource$1("lib/index.css");
        this.copyResource$1("lib/index.js");
        this.copyResource$1("lib/template.css");
        this.copyResource$1("lib/template.js");
        this.copyResource$1("lib/class.png");
        this.copyResource$1("lib/class_big.png");
        this.copyResource$1("lib/object.png");
        this.copyResource$1("lib/object_big.png");
        this.copyResource$1("lib/trait.png");
        this.copyResource$1("lib/trait_big.png");
        this.copyResource$1("lib/package.png");
        this.copyResource$1("lib/package_big.png");
        new Index(modelRoot).writeFor(this);
        HashSet written$1 = HashSet$.MODULE$.empty();
        this.writeTemplate$1(modelRoot, written$1);
    }

    public File siteRoot() {
        return new File((String)this.settings().outdir().value());
    }

    public String encoding() {
        return "UTF-8";
    }

    public Settings settings() {
        return this.settings;
    }

    public Reporter reporter() {
        return this.reporter;
    }
}

