/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Iterator;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipArchive
extends PlainFile
implements ScalaObject {
    private DirEntry root;
    private final ZipFile archive;

    public ZipArchive(File file, ZipFile archive) {
        this.archive = archive;
        super(file);
        Predef$.MODULE$.assert(archive != null);
    }

    private DirEntry getDir(Map dirs, String path) {
        Option option;
        block4: {
            DirEntry dirEntry;
            block3: {
                block2: {
                    option = dirs.get((Object)path);
                    if (!(option instanceof Some)) break block2;
                    dirEntry = (DirEntry)((Some)option).x();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                int index = path.lastIndexOf(47, path.length() - 2);
                String name = index < 0 ? path : path.substring(index + 1);
                String home = index < 0 ? "/" : path.substring(0, index + 1);
                DirEntry parent = this.getDir(dirs, home);
                DirEntry dir = new DirEntry(this, parent, name.substring(0, name.length() - 1), path);
                parent.entries().update((Object)name, (Object)dir);
                dirs.update((Object)path, (Object)dir);
                dirEntry = dir;
            }
            return dirEntry;
        }
        throw new MatchError((Object)option);
    }

    private void load() {
        this.root_$eq(new DirEntry(this, this, "<root>", "/"));
        HashMap dirs = new HashMap();
        dirs.update((Object)"/", (Object)this.root());
        Enumeration<? extends ZipEntry> entries = this.archive().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String path = entry.getName();
            Predef$.MODULE$.assert(entry.isDirectory() == path.endsWith("/"), (Object)new StringBuilder().append((Object)this.toString()).append((Object)" - ").append((Object)path).toString());
            if (entry.isDirectory()) {
                DirEntry dir = this.getDir((Map)dirs, path);
                Predef$.MODULE$.assert(dir.entry() == null, (Object)new StringBuilder().append((Object)this.toString()).append((Object)" - ").append((Object)path).toString());
                dir.entry_$eq(entry);
                continue;
            }
            int index = path.lastIndexOf(47);
            String name = index < 0 ? path : path.substring(index + 1);
            String home = index < 0 ? "/" : path.substring(0, index + 1);
            DirEntry parent = this.getDir((Map)dirs, home);
            parent.entries().update((Object)name, (Object)new FileEntry(this, parent, name, path, entry));
        }
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        if (this.root() == null) {
            this.load();
        }
        return this.root().lookupName(name, directory);
    }

    @Override
    public Iterator<AbstractFile> elements() {
        if (this.root() == null) {
            this.load();
        }
        return this.root().elements();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    private void root_$eq(DirEntry x$1) {
        this.root = x$1;
    }

    private DirEntry root() {
        return this.root;
    }

    public ZipFile archive() {
        return this.archive;
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public final /* synthetic */ ZipArchive $outer;
        private final AbstractFile container;

        public Entry(ZipArchive $outer, AbstractFile container, String name, String path) {
            this.container = container;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(name, path);
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$Entry$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object that) {
            if (!super.equals(that)) return false;
            Object object = that;
            if (!(object instanceof Entry)) return false;
            if (((Entry)object).scala$tools$nsc$io$ZipArchive$Entry$$$outer() != this.scala$tools$nsc$io$ZipArchive$Entry$$$outer()) return false;
            AbstractFile abstractFile = this.container();
            AbstractFile abstractFile2 = ((Entry)object).container();
            if (abstractFile != null) {
                if (!abstractFile.equals(abstractFile2)) return false;
                return true;
            }
            if (abstractFile2 == null) return true;
            return false;
        }

        public int hashCode() {
            return super.hashCode() + this.container().hashCode();
        }

        public String pathInArchive() {
            return super.path();
        }

        public final ZipFile getArchive() {
            return this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().archive();
        }

        public final String path() {
            return new StringBuilder().append((Object)this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().toString()).append((Object)"(").append((Object)this.pathInArchive()).append((Object)")").toString();
        }

        public AbstractFile container() {
            return this.container;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DirEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;
        private final Map entries = new HashMap();

        public DirEntry(ZipArchive $outer, AbstractFile container, String name, String path) {
            super($outer, container, name, path);
        }

        @Override
        public AbstractFile lookupName(String name, boolean directory) {
            Option option;
            block4: {
                AbstractFile abstractFile;
                block3: {
                    block2: {
                        option = this.entries().get((Object)(directory ? new StringBuilder().append((Object)name).append((Object)"/").toString() : name));
                        if (!(option instanceof Some)) break block2;
                        abstractFile = (AbstractFile)((Some)option).x();
                        break block3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                    abstractFile = null;
                }
                return abstractFile;
            }
            throw new MatchError((Object)option);
        }

        @Override
        public Iterator<AbstractFile> elements() {
            return this.entries().values();
        }

        @Override
        public long lastModified() {
            return this.entry() == null ? super.lastModified() : this.entry().getTime();
        }

        public Nothing$ input() {
            throw new Error("cannot read directories");
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry x$1) {
            this.entry = x$1;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map<String, Entry> entries() {
            return this.entries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class FileEntry
    extends Entry
    implements ScalaObject {
        private final ZipEntry entry;

        public FileEntry(ZipArchive $outer, AbstractFile container, String name, String path, ZipEntry entry) {
            this.entry = entry;
            super($outer, container, name, path);
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$FileEntry$$$outer() {
            return this.$outer;
        }

        public Some<Integer> size() {
            return new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.entry().getSize())));
        }

        @Override
        public InputStream input() {
            return this.archive().getInputStream(this.entry());
        }

        @Override
        public long lastModified() {
            return this.entry().getTime();
        }

        public ZipFile archive() {
            return this.scala$tools$nsc$io$ZipArchive$FileEntry$$$outer().archive();
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }
}

