/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.ScalaObject;
import scala.Seq;
import scala.Tuple2;
import scala.compat.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Global;
import scala.tools.nsc.Interpreter$;
import scala.tools.nsc.ScriptRunner$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.util.CompoundSourceFile;
import scala.tools.nsc.util.SourceFile;
import scala.tools.nsc.util.SourceFileFragment;

public final class ScriptRunner$
implements ScalaObject {
    public static final ScriptRunner$ MODULE$;

    static {
        ScriptRunner$ scriptRunner$ = new ScriptRunner$();
    }

    public ScriptRunner$() {
        MODULE$ = this;
    }

    private final boolean jarOK$0(String string, File file) {
        return file.canRead() && file.lastModified() > new File(string).lastModified();
    }

    private final Tuple2 compile$0(GenericRunnerSettings genericRunnerSettings, String string) {
        Tuple2 tuple2;
        File compiledPath = File.createTempFile("scalascript", "");
        compiledPath.delete();
        compiledPath.mkdirs();
        genericRunnerSettings.outdir().value_$eq(compiledPath.getPath());
        if (!genericRunnerSettings.nocompdaemon().value()) {
            boolean compok = this.compileWithDaemon(genericRunnerSettings, string);
            tuple2 = new Tuple2((Object)compiledPath, (Object)BoxesUtility.boxToBoolean((boolean)compok));
        } else {
            ConsoleReporter reporter = new ConsoleReporter(genericRunnerSettings);
            Global compiler$0 = new Global(genericRunnerSettings, reporter);
            Global.Run cr = new Global.Run(compiler$0);
            cr.compileSources(List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new SourceFile[]{this.wrappedScript(string, new anonfun.6(compiler$0))})));
            tuple2 = new Tuple2((Object)compiledPath, (Object)BoxesUtility.boxToBoolean((!reporter.hasErrors() ? 1 : 0) != 0));
        }
        return tuple2;
    }

    public final void addFromDir$0(File dir, String prefix$0, JarOutputStream jarOutputStream, byte[] byArray) {
        new BoxedObjectArray((Object[])dir.listFiles()).foreach((Function1)new anonfun.0(jarOutputStream, byArray, prefix$0));
    }

    public void runScript(GenericRunnerSettings settings$0, String scriptFile, List scriptArgs$0) {
        File f = new File(scriptFile);
        if (f.exists() && !f.isDirectory()) {
            this.withCompiledScript(settings$0, scriptFile, new anonfun.7(settings$0, scriptArgs$0));
            return;
        }
        Console$.MODULE$.println((Object)("no such file: " + scriptFile));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void withCompiledScript(GenericRunnerSettings settings$1, String scriptFile$0, Function1 handler) {
        if (!settings$1.savecompiled().value()) {
            Tuple2 tuple2 = this.compile$0(settings$1, scriptFile$0);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            File file = (File)tuple2._1();
            boolean bl = BoxesUtility.unboxToBoolean((Object)tuple2._2());
            File compiledPath3 = file;
            boolean compok = bl;
            Tuple2 tuple22 = new Tuple2((Object)compiledPath3, (Object)BoxesUtility.boxToBoolean((boolean)compok));
            File compiledPath2 = (File)tuple22._1();
            boolean compok2 = BoxesUtility.unboxToBoolean((Object)tuple22._2());
            try {
                if (compok2) {
                    handler.apply((Object)compiledPath2.getPath());
                }
                Interpreter$.MODULE$.deleteRecursively(compiledPath2);
                return;
            }
            catch (Throwable throwable) {
                void compiledPath;
                Interpreter$.MODULE$.deleteRecursively((File)compiledPath);
                throw throwable;
            }
        }
        File jarFile$0 = this.jarFileFor(scriptFile$0);
        if (this.jarOK$0(scriptFile$0, jarFile$0)) {
            handler.apply((Object)jarFile$0.getAbsolutePath());
            return;
        }
        jarFile$0.delete();
        Tuple2 tuple2 = this.compile$0(settings$1, scriptFile$0);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        File file = (File)tuple2._1();
        boolean bl = BoxesUtility.unboxToBoolean((Object)tuple2._2());
        File compiledPath4 = file;
        boolean compok = bl;
        Tuple2 tuple23 = new Tuple2((Object)compiledPath4, (Object)BoxesUtility.boxToBoolean((boolean)compok));
        File compiledPath = (File)tuple23._1();
        boolean compok3 = BoxesUtility.unboxToBoolean((Object)tuple23._2());
        try {
            if (compok3) {
                this.tryMakeJar(jarFile$0, compiledPath);
                if (!this.jarOK$0(scriptFile$0, jarFile$0)) {
                    handler.apply((Object)compiledPath.getPath());
                } else {
                    Interpreter$.MODULE$.deleteRecursively(compiledPath);
                    handler.apply((Object)jarFile$0.getAbsolutePath());
                }
            }
            Interpreter$.MODULE$.deleteRecursively(compiledPath);
            return;
        }
        catch (Throwable throwable) {
            Interpreter$.MODULE$.deleteRecursively(compiledPath);
            throw throwable;
        }
    }

    private boolean compileWithDaemon(GenericRunnerSettings settings, String scriptFileIn) {
        List coreCompArgs;
        String scriptFile = CompileClient$.MODULE$.absFileName(scriptFileIn);
        List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new Settings.StringSetting[]{settings.classpath(), settings.sourcepath(), settings.bootclasspath(), settings.extdirs(), settings.outdir()})).foreach((Function1)new anonfun.1());
        List compSettingNames$0 = new Settings(new anonfun.2()).allSettings().map((Function1)new anonfun.3());
        List compSettings = settings.allSettings().filter((Function1)new anonfun.4(compSettingNames$0));
        List list = coreCompArgs = (List)compSettings.foldLeft((Object)Nil$.MODULE$, (Function2)new anonfun.5());
        List compArgs = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"-Xscript", scriptFile})).$colon$colon$colon(list);
        Socket socket = CompileSocket$.MODULE$.getOrCreateSocket("");
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.println(CompileSocket$.MODULE$.getPassword(socket.getPort()));
        out.println(compArgs.mkString("", "\u0000", ""));
        boolean compok = true;
        String fromServer = in.readLine();
        while (fromServer != null) {
            Console$.MODULE$.println((Object)fromServer);
            if (CompileSocket$.MODULE$.errorPattern().matcher(fromServer).matches()) {
                compok = false;
            }
            fromServer = in.readLine();
        }
        in.close();
        out.close();
        socket.close();
        return compok;
    }

    public SourceFile wrappedScript(String filename, Function1 getSourceFile) {
        SourceFile preamble = new SourceFile("<script preamble>", "package $scalascript\nobject Main {\n  def main(argv: Array[String]): Unit = {\n  val args = argv;\n".toCharArray());
        File f = new File(filename);
        SourceFileFragment middle = new SourceFileFragment((SourceFile)getSourceFile.apply((Object)new PlainFile(f)), this.headerLength(filename), (int)f.length());
        SourceFile end = new SourceFile("<script trailer>", "\n} }\n".toCharArray());
        return new CompoundSourceFile((Seq)new BoxedObjectArray((Object[])new SourceFile[]{preamble, middle, end}));
    }

    private int headerLength(String filename) {
        String fileContents = this.contentsOfFile(filename);
        if (!fileContents.startsWith("#!") && !fileContents.startsWith("::#!")) {
            return 0;
        }
        Matcher matcher = Pattern.compile("^(::)?!#.*(\\r|\\n|\\r\\n)", 8).matcher(fileContents);
        if (!matcher.find()) {
            throw new Error("script file does not close its header with !# or ::!#");
        }
        return matcher.end();
    }

    private String contentsOfFile(String filename) {
        int n;
        StringBuilder strbuf = new StringBuilder();
        FileReader reader = new FileReader(filename);
        char[] cbuf = new char[1024];
        while ((n = reader.read(cbuf)) > 0) {
            strbuf.append(cbuf, 0, n);
        }
        return strbuf.toString();
    }

    private Object tryMakeJar(File jarFile, File sourcePath) {
        Boolean bl;
        try {
            FileOutputStream jarFileStream = new FileOutputStream(jarFile);
            JarOutputStream jar$0 = new JarOutputStream(jarFileStream);
            byte[] buf$0 = new byte[10240];
            this.addFromDir$0(sourcePath, "", jar$0, buf$0);
            jar$0.close();
            bl = BoxedUnit.UNIT;
        }
        catch (Error error) {
            bl = BoxesUtility.boxToBoolean((boolean)jarFile.delete());
        }
        return bl;
    }

    private File jarFileFor(String scriptFile) {
        String filename = !scriptFile.matches(".*\\.[^.\\\\/]*") ? scriptFile + ".jar" : scriptFile.replaceFirst("\\.[^.\\\\/]*$", ".jar");
        return new File(filename);
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

