/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import java.io.PrintWriter;
import scala.;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.ScalaObject;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.tools.nsc.backend.icode.BasicBlocks;
import scala.tools.nsc.backend.icode.ExceptionHandlers;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Linearizers;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;
import scala.tools.nsc.backend.icode.Printers$TextPrinter$;

public interface Printers
extends ScalaObject {

    public class TextPrinter
    implements ScalaObject {
        public /* synthetic */ ICodes $outer;
        private Members.IClass clazz;
        private final int TAB;
        private PrintWriter out;
        private int margin;
        private Linearizers.Linearizer lin;

        public TextPrinter(ICodes iCodes, PrintWriter printWriter, Linearizers.Linearizer linearizer) {
            this.lin = linearizer;
            if (iCodes != null) {
                this.$outer = iCodes;
                this.margin = 0;
                this.out = printWriter;
                return;
            }
            throw new NullPointerException();
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$Printers$TextPrinter$$$outer() {
            return this.$outer;
        }

        public void printInstruction(Opcodes.Instruction instruction) {
            if (this.scala$tools$nsc$backend$icode$Printers$TextPrinter$$$outer().global().settings().Xdce().value()) {
                this.print(!instruction.useful() ? " * " : "   ");
            }
            this.println(instruction.toString());
        }

        public void printBlock(BasicBlocks.BasicBlock basicBlock) {
            this.print(BoxesUtility.boxToInteger((int)basicBlock.label()));
            if (basicBlock.loopHeader()) {
                this.print("[loop header]");
            }
            this.print(": ");
            this.indent();
            this.println();
            basicBlock.toList().foreach((Function1)new TextPrinter$$anonfun$5(this));
            this.undent();
            this.println();
        }

        public void printExceptionHandler(ExceptionHandlers.ExceptionHandler exceptionHandler) {
            this.indent();
            this.println("catch (" + exceptionHandler.cls().simpleName() + ") in " + exceptionHandler.covered() + " starting at: " + exceptionHandler.startBlock());
            this.println("consisting of blocks: " + exceptionHandler.blocks());
            this.undent();
            this.println("with finalizer: " + exceptionHandler.finalizer());
        }

        public void printParam(Members.Local local) {
            this.print(local.sym().name());
            this.print(": ");
            this.print(local.sym().info());
            this.print(" (");
            this.print(local.kind());
            this.print(")");
        }

        public void printMethod(Members.IMethod iMethod) {
            this.print("def ");
            this.print(iMethod.symbol().name());
            this.print("(");
            this.printList(new TextPrinter$$anonfun$2(this), iMethod.params().reverse(), ", ");
            this.print(")");
            this.print(": ");
            this.print(iMethod.symbol().info().resultType());
            if (!iMethod.isDeferred()) {
                this.println(" {");
                this.println("locals: " + iMethod.locals().mkString("", ", ", ""));
                this.println("startBlock: " + iMethod.code().startBlock());
                this.println("blocks: " + iMethod.code().blocks().mkString("[", ",", "]"));
                this.println();
                this.lin.linearize(iMethod).foreach((Function1)new TextPrinter$$anonfun$3(this));
                this.println("}");
                this.indent();
                this.println("Exception handlers: ");
                iMethod.exh().foreach((Function1)new TextPrinter$$anonfun$4(this));
                this.undent();
                this.println();
            } else {
                this.println();
            }
        }

        public void printField(Members.IField iField) {
            this.print(iField.symbol().keyString());
            this.print(" ");
            this.print(iField.symbol().nameString());
            this.print(": ");
            this.println(iField.symbol().info().toString());
        }

        public void printClass(Members.IClass iClass) {
            this.clazz_$eq(iClass);
            this.print(iClass.symbol().toString());
            this.print(" extends ");
            this.printList(iClass.symbol().info().parents(), ", ");
            this.indent();
            this.println(" {");
            this.println("// fields:");
            iClass.fields().foreach((Function1)new TextPrinter$$anonfun$0(this));
            this.println();
            this.println("// methods");
            iClass.methods().foreach((Function1)new TextPrinter$$anonfun$1(this));
            this.undent();
            this.println();
            this.println("}");
        }

        private void clazz_$eq(Members.IClass iClass) {
            this.clazz = iClass;
        }

        private Members.IClass clazz() {
            return this.clazz;
        }

        public void printList(Function1 function1, List list, String string) {
            List list2 = list;
            if (list2 != Nil$.MODULE$) {
                if (!(list2 instanceof .colon.colon)) {
                    throw new MatchError((Object)list2);
                }
                .colon.colon colon2 = (.colon.colon)list2;
                if (colon2.tl$0() != Nil$.MODULE$) {
                    function1.apply(colon2.hd());
                    this.print(string);
                    this.printList(function1, colon2.tl$0(), string);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = (BoxedUnit)function1.apply(colon2.hd());
                }
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public void printList(List list, String string) {
            List list2 = list;
            if (list2 != Nil$.MODULE$) {
                if (!(list2 instanceof .colon.colon)) {
                    throw new MatchError((Object)list2);
                }
                .colon.colon colon2 = (.colon.colon)list2;
                if (colon2.tl$0() != Nil$.MODULE$) {
                    this.print(colon2.hd());
                    this.print(string);
                    this.printList(colon2.tl$0(), string);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.print(colon2.hd());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public void println() {
            this.out().println();
            int n = 0;
            while (n < this.margin()) {
                this.print(" ");
                ++n;
            }
            return;
        }

        public void println(String string) {
            this.print(string);
            this.println();
        }

        public void print(Object object) {
            this.print(object.toString());
        }

        public void print(String string) {
            this.out().print(string);
        }

        public void undent() {
            this.margin_$eq(this.margin() - 2);
        }

        public void indent() {
            this.margin_$eq(this.margin() + 2);
        }

        public void setWriter(PrintWriter printWriter) {
            this.out_$eq(printWriter);
        }

        public final int TAB() {
            return 2;
        }

        public void out_$eq(PrintWriter printWriter) {
            this.out = printWriter;
        }

        public PrintWriter out() {
            return this.out;
        }

        public void margin_$eq(int n) {
            this.margin = n;
        }

        public int margin() {
            return this.margin;
        }

        public int $tag() {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }
}

