/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Array$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.util.NoPosition$;
import scala.reflect.internal.util.Position;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.PlainFile;
import scala.reflect.io.ZipArchive;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.reporters.Reporter;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001-\u0011AbU8ve\u000e,'+Z1eKJT!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\rq7o\u0019\u0006\u0003\u000f!\tQ\u0001^8pYNT\u0011!C\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t\u0001\"\u0003\u0002\u0010\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\bI\u0016\u001cw\u000eZ3s!\t\u0019\"$D\u0001\u0015\u0015\t)b#A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005]A\u0012a\u00018j_*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0015\u00059\u0019\u0005.\u0019:tKR$UmY8eKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\te\u0016\u0004xN\u001d;feB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\ne\u0016\u0004xN\u001d;feNL!a\t\u0011\u0003\u0011I+\u0007o\u001c:uKJDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDcA\u0014*UA\u0011\u0001\u0006A\u0007\u0002\u0005!)\u0011\u0003\na\u0001%!)Q\u0004\na\u0001=!9A\u0006\u0001b\u0001\n\u0013i\u0013!\u00022zi\u0016\u001cX#\u0001\u0018\u0011\u0005=\u0002T\"\u0001\f\n\u0005E2\"A\u0003\"zi\u0016\u0014UO\u001a4fe\"11\u0007\u0001Q\u0001\n9\naAY=uKN\u0004\u0003bB\u001b\u0001\u0001\u0004%IAN\u0001\u0006G\"\f'o]\u000b\u0002oA\u0011q\u0006O\u0005\u0003sY\u0011!b\u00115be\n+hMZ3s\u0011\u001dY\u0004\u00011A\u0005\nq\n\u0011b\u00195beN|F%Z9\u0015\u0005u\u0002\u0005CA\u0007?\u0013\ty\u0004B\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004BB\"\u0001A\u0003&q'\u0001\u0004dQ\u0006\u00148\u000f\t\u0005\u0006\u000b\u0002!IAR\u0001\u0014e\u0016\u0004xN\u001d;F]\u000e|G-\u001b8h\u000bJ\u0014xN\u001d\u000b\u0003{\u001dCQ\u0001\u0013#A\u0002%\u000b\u0001BZ5mK:\fW.\u001a\t\u0003\u0015Fs!aS(\u0011\u00051CQ\"A'\u000b\u00059S\u0011A\u0002\u001fs_>$h(\u0003\u0002Q\u0011\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001\u0006\u0002C\u0003V\u0001\u0011\u0005a+\u0001\u0003sK\u0006$GCA,^!\ri\u0001LW\u0005\u00033\"\u0011Q!\u0011:sCf\u0004\"!D.\n\u0005qC!\u0001B\"iCJDQA\u0018+A\u0002}\u000bAAZ5mKB\u0011\u0001m\u0019\b\u0003Q\u0005L!A\u0019\u0002\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\u0006\u0015\u001aKG.\u001a\u0006\u0003E\nAQ!\u0016\u0001\u0005\u0002\u001d$\"a\u00165\t\u000by3\u0007\u0019A5\u0011\u0005\u0001T\u0017BA6f\u00051\t%m\u001d;sC\u000e$h)\u001b7f\u0011\u0015)\u0006\u0001\"\u0005n)\t9f\u000eC\u0003pY\u0002\u0007\u0001/A\u0003j]B,H\u000f\u0005\u0002ri6\t!O\u0003\u0002t-\u0005A1\r[1o]\u0016d7/\u0003\u0002ve\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\")Q\u000b\u0001C\toR\u0011q\u000b\u001f\u0005\u0006YY\u0004\rA\f\u0005\u0006u\u0002!Ia_\u0001\ni\u0016\u0014X.\u001b8bi\u0016$\"a\u0016?\t\u000bUJ\b\u0019A\u001c\b\u000by\u0014\u0001\u0012A@\u0002\u0019M{WO]2f%\u0016\fG-\u001a:\u0011\u0007!\n\tA\u0002\u0004\u0002\u0005!\u0005\u00111A\n\u0004\u0003\u0003a\u0001bB\u0013\u0002\u0002\u0011\u0005\u0011q\u0001\u000b\u0002\u007f\"A\u00111BA\u0001\t\u0003\ti!\u0001\u0004eK\u000e|G-\u001a\u000b\no\u0005=\u0011\u0011CA\n\u0003+Aa!EA\u0005\u0001\u0004\u0011\u0002B\u0002\u0017\u0002\n\u0001\u0007a\u0006\u0003\u00046\u0003\u0013\u0001\ra\u000e\u0005\t\u0003/\tI\u00011\u0001\u0002\u001a\u0005QQM\u001c3PM&s\u0007/\u001e;\u0011\u00075\tY\"C\u0002\u0002\u001e!\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\"\u0005\u0005A\u0011AA\u0012\u0003\u00151G.^:i)\u00159\u0014QEA\u0014\u0011\u0019\t\u0012q\u0004a\u0001%!1Q'a\bA\u0002]B\u0001\"a\u000b\u0002\u0002\u0011%\u0011QF\u0001\u0011S:\u001c'/Z1tK\u000e\u000b\u0007/Y2jif$2aNA\u0018\u0011\u001d\t\t$!\u000bA\u0002]\naAY;gM\u0016\u0014\b")
public class SourceReader {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private void reportEncodingError(String filename) {
        this.reporter.error((Position)NoPosition$.MODULE$, new StringBuilder(91).append("IO error while decoding ").append(filename).append(" with ").append(this.decoder.charset()).append("\n").append("Please try specifying another one using the -encoding option").toString());
    }

    public char[] read(File file) {
        char[] cArray;
        try (FileChannel c = new FileInputStream(file).getChannel();){
            try {
                cArray = this.read(c);
            }
            catch (Exception exception) {
                this.reportEncodingError(String.valueOf(file));
                cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
            }
        }
        return cArray;
    }

    public char[] read(AbstractFile file) {
        try {
            char[] cArray;
            if (file instanceof PlainFile) {
                PlainFile plainFile = (PlainFile)file;
                cArray = this.read(plainFile.file());
            } else if (file instanceof ZipArchive.Entry) {
                ZipArchive.Entry entry = (ZipArchive.Entry)file;
                cArray = this.read(Channels.newChannel(entry.input()));
            } else {
                cArray = this.read(ByteBuffer.wrap(file.toByteArray()));
            }
            return cArray;
        }
        catch (Exception exception) {
            this.reportEncodingError(String.valueOf(file));
            return (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
        }
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

