/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JMethod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JExceptionsAttribute
extends JAttribute {
    private JConstantPool pool;
    protected int[] indexTable;
    protected int count;

    public JExceptionsAttribute(FJBGContext context, JClass clazz2, JMethod owner) {
        super(context, clazz2);
        this.pool = clazz2.pool;
        this.count = 0;
        this.indexTable = new int[8];
        assert (clazz2 == owner.getOwner());
    }

    public JExceptionsAttribute(FJBGContext context, JClass clazz2, Object owner, String name, int size2, DataInputStream stream) throws IOException {
        super(context, clazz2, name);
        this.pool = clazz2.pool;
        this.count = stream.readShort();
        this.indexTable = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.indexTable[i] = stream.readShort();
        }
        assert (name.equals(this.getName()));
    }

    public void addEntry(int classIndex) {
        if (this.count >= this.indexTable.length) {
            int[] newIT = new int[this.indexTable.length * 2];
            System.arraycopy(this.indexTable, 0, newIT, 0, this.indexTable.length);
            this.indexTable = newIT;
        }
        this.indexTable[this.count++] = classIndex;
    }

    public String getName() {
        return "Exceptions";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  Exceptions: ");
        for (int i = 0; i < this.indexTable.length; ++i) {
            buf.append("\n   throws ");
            buf.append(JClass.toExternalName(this.pool.lookupClass(this.indexTable[i])));
        }
        buf.append("\n");
        return buf.toString();
    }

    protected int getSize() {
        return 2 + this.indexTable.length * 2;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.count);
        for (int i = 0; i < this.count; ++i) {
            stream.writeShort(this.indexTable[i]);
        }
    }
}

