/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JType;

public class JMethodType
extends JType {
    protected final JType returnType;
    protected final JType[] argTypes;
    protected String signature = null;
    public static final JMethodType ARGLESS_VOID_FUNCTION = new JMethodType(JType.VOID, JType.EMPTY_ARRAY);

    public JMethodType(JType returnType, JType[] argTypes) {
        this.returnType = returnType;
        this.argTypes = argTypes;
    }

    public JType getReturnType() {
        return this.returnType;
    }

    public JType[] getArgumentTypes() {
        return this.argTypes;
    }

    public int getSize() {
        throw new UnsupportedOperationException();
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            for (int i = 0; i < this.argTypes.length; ++i) {
                buf.append(this.argTypes[i].getSignature());
            }
            buf.append(')');
            buf.append(this.returnType.getSignature());
            this.signature = buf.toString();
        }
        return this.signature;
    }

    public int getTag() {
        return 15;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            buf.append(this.argTypes[i].toString());
        }
        buf.append(')');
        buf.append(this.returnType.toString());
        return buf.toString();
    }

    public int getArgsSize() {
        int size2 = 0;
        for (int i = 0; i < this.argTypes.length; ++i) {
            size2 += this.argTypes[i].getSize();
        }
        return size2;
    }

    public int getProducedStack() {
        return this.returnType.getSize() - this.getArgsSize();
    }

    public boolean isCompatibleWith(JType other) {
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof JMethodType) {
            return ((JMethodType)o).getSignature().equals(this.getSignature());
        }
        return false;
    }

    public int hashCode() {
        if (this.signature == null) {
            return 0;
        }
        return this.signature.hashCode();
    }
}

