/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import scala.tools.jline.Terminal;
import scala.tools.jline.TerminalFactory;
import scala.tools.jline.internal.Configuration;
import scala.tools.jline.internal.Log;

public abstract class TerminalSupport
implements Terminal {
    public static String DEFAULT_KEYBINDINGS_PROPERTIES = "keybindings.properties";
    public static final String JLINE_SHUTDOWNHOOK = "jline.shutdownhook";
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HEIGHT = 24;
    private Thread shutdownHook;
    private boolean shutdownHookEnabled;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean bl) {
        this.supported = bl;
        this.shutdownHookEnabled = Configuration.getBoolean(JLINE_SHUTDOWNHOOK, false);
    }

    public void init() throws Exception {
        this.installShutdownHook(new RestoreHook());
    }

    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        this.removeShutdownHook();
    }

    public void reset() throws Exception {
        this.restore();
        this.init();
    }

    protected void installShutdownHook(Thread thread) {
        if (!this.shutdownHookEnabled) {
            Log.debug("Not install shutdown hook " + thread + " because they are disabled.");
            return;
        }
        assert (thread != null);
        if (this.shutdownHook != null) {
            throw new IllegalStateException("Shutdown hook already installed");
        }
        try {
            Runtime.getRuntime().addShutdownHook(thread);
            this.shutdownHook = thread;
        }
        catch (AbstractMethodError abstractMethodError) {
            Log.trace("Failed to register shutdown hook: ", abstractMethodError);
        }
    }

    protected void removeShutdownHook() {
        if (!this.shutdownHookEnabled) {
            return;
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (AbstractMethodError abstractMethodError) {
                Log.trace("Failed to remove shutdown hook: ", abstractMethodError);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
    }

    public final boolean isSupported() {
        return this.supported;
    }

    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean bl) {
        this.ansiSupported = bl;
        Log.debug("Ansi supported: ", bl);
    }

    public OutputStream wrapOutIfNeeded(OutputStream outputStream) {
        return outputStream;
    }

    public boolean hasWeirdWrap() {
        return true;
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 24;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void setEchoEnabled(boolean bl) {
        this.echoEnabled = bl;
        Log.debug("Echo enabled: ", bl);
    }

    public int readCharacter(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    public int readVirtualKey(InputStream inputStream) throws IOException {
        return this.readCharacter(inputStream);
    }

    public InputStream getDefaultBindings() {
        return TerminalSupport.class.getResourceAsStream(DEFAULT_KEYBINDINGS_PROPERTIES);
    }

    protected class RestoreHook
    extends Thread {
        protected RestoreHook() {
        }

        public void start() {
            try {
                TerminalSupport.this.restore();
            }
            catch (Exception exception) {
                Log.trace("Failed to restore: ", exception);
            }
        }
    }
}

