/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console;

public class CursorBuffer {
    private boolean overTyping = false;
    public int cursor = 0;
    public final StringBuilder buffer = new StringBuilder();

    public boolean isOverTyping() {
        return this.overTyping;
    }

    public void setOverTyping(boolean bl) {
        this.overTyping = bl;
    }

    public int length() {
        return this.buffer.length();
    }

    public char current() {
        if (this.cursor <= 0) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor - 1);
    }

    public void write(char c) {
        this.buffer.insert(this.cursor++, c);
        if (this.isOverTyping() && this.cursor < this.buffer.length()) {
            this.buffer.deleteCharAt(this.cursor);
        }
    }

    public void write(CharSequence charSequence) {
        assert (charSequence != null);
        if (this.buffer.length() == 0) {
            this.buffer.append(charSequence);
        } else {
            this.buffer.insert(this.cursor, charSequence);
        }
        this.cursor += charSequence.length();
        if (this.isOverTyping() && this.cursor < this.buffer.length()) {
            this.buffer.delete(this.cursor, this.cursor + charSequence.length());
        }
    }

    public boolean clear() {
        if (this.buffer.length() == 0) {
            return false;
        }
        this.buffer.delete(0, this.buffer.length());
        this.cursor = 0;
        return true;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

