/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.Messages;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.DotSearchListener;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchListener;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.PercentLengthLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lanceur
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    protected ASolverFactory<ISolver> factory;
    private String filename;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$Lanceur;

    public static void main(String[] args) {
        Lanceur lanceur = new Lanceur();
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("C", "conflictbased", false, "conflict based timeout (for deterministic behavior)");
        options.addOption("d", "dot", true, "create a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("r", "replay", true, "replay stored results");
        options.addOption("b", "backup", true, "backup results in specified file");
        options.addOption("u", "update", false, "update results file if needed");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        Option op = options.getOption("l");
        op.setArgName("libname");
        op = options.getOption("s");
        op.setArgName("solvername");
        op = options.getOption("t");
        op.setArgName("delay");
        options.getOption("d");
        return options;
    }

    protected ISolver configureSolver(String[] args) {
        Options options = this.createCLIOptions();
        if (args.length == 0) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            String solvername;
            CommandLine cmd = new PosixParser().parse(options, args);
            String framework = cmd.getOptionValue("l");
            if (framework == null) {
                framework = "minisat";
            }
            try {
                Class<?> clazz = Class.forName(new StringBuffer().append("org.sat4j.").append(framework).append(".SolverFactory").toString());
                Class[] params = new Class[]{};
                Method m = clazz.getMethod("instance", params);
                this.factory = (ASolverFactory)m.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                System.err.println(Messages.getString((String)"Lanceur.wrong.framework"));
                e.printStackTrace();
            }
            ISolver asolver = cmd.hasOption("S") ? this.configureFromString(cmd.getOptionValue("S")) : ((solvername = cmd.getOptionValue("s")) == null ? this.factory.defaultSolver() : this.factory.createSolverByName(solvername));
            String timeout = cmd.getOptionValue("t");
            if (timeout == null) {
                timeout = cmd.getOptionValue("T");
                if (timeout != null) {
                    asolver.setTimeoutMs(Long.parseLong(timeout));
                }
            } else if (cmd.hasOption("C")) {
                asolver.setTimeoutOnConflicts(Integer.parseInt(timeout));
            } else {
                asolver.setTimeout(Integer.parseInt(timeout));
            }
            this.filename = cmd.getOptionValue("f");
            if (cmd.hasOption("d")) {
                String dotfilename = null;
                if (this.filename != null) {
                    dotfilename = cmd.getOptionValue("d");
                }
                if (dotfilename == null) {
                    dotfilename = "sat4j.dot";
                }
                ((Solver)asolver).setSearchListener((SearchListener)new DotSearchListener(dotfilename));
            }
            if (cmd.hasOption("m")) {
                this.setSilent(true);
            }
            int others = 0;
            String[] rargs = cmd.getArgs();
            if (this.filename == null) {
                this.filename = rargs[others++];
            }
            while (others < rargs.length) {
                String[] param = rargs[others].split("=");
                if (!$assertionsDisabled && param.length != 2) {
                    throw new AssertionError();
                }
                this.log(new StringBuffer().append("setting ").append(param[0]).append(" to ").append(param[1]).toString());
                try {
                    BeanUtils.setProperty((Object)asolver, (String)param[0], (Object)param[1]);
                }
                catch (Exception e) {
                    this.log(new StringBuffer().append("Cannot set parameter : ").append(args[others]).toString());
                }
                ++others;
            }
            this.log(asolver.toString("c "));
            return asolver;
        }
        catch (ParseException e1) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    protected Reader createReader(ISolver solver, String problemname) {
        return new InstanceReader(solver);
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        this.showAvailableSolvers(this.factory);
    }

    protected String getInstanceName(String[] args) {
        return this.filename;
    }

    private final ISolver configureFromString(String solverconfig) {
        StringTokenizer stk = new StringTokenizer(solverconfig, ",");
        Properties pf = new Properties();
        while (stk.hasMoreElements()) {
            String token = stk.nextToken();
            String[] couple = token.split("=");
            pf.setProperty(couple[0], couple[1]);
        }
        DataStructureFactory dsf = (DataStructureFactory)this.setupObject("DSF", pf, new MixedDataStructureDaniel());
        LearningStrategy learning = (LearningStrategy)this.setupObject("LEARNING", pf, new PercentLengthLearning());
        IOrder order = (IOrder)this.setupObject("ORDER", pf, new VarOrderHeap());
        RestartStrategy restarter = (RestartStrategy)this.setupObject("RESTARTS", pf, new MiniSATRestarts());
        Solver solver = new Solver((AssertingClauseGenerator)new FirstUIP(), learning, dsf, order, restarter);
        learning.setSolver(solver);
        solver.setSimplifier(pf.getProperty("SIMP", "NO_SIMPLIFICATION"));
        SearchParams params = this.setupObject("PARAMS", pf, new SearchParams());
        solver.setSearchParams(params);
        return solver;
    }

    private final <T> T setupObject(String component, Properties pf, T defaultcomp) {
        try {
            String configline = pf.getProperty(component);
            if (configline == null) {
                this.log(new StringBuffer().append("using default component ").append(defaultcomp).append(" for ").append(component).toString());
                return defaultcomp;
            }
            this.log(new StringBuffer().append("configuring ").append(component).toString());
            String[] config = configline.split("/");
            Object comp = Class.forName(config[0]).newInstance();
            for (int i = 1; i < config.length; ++i) {
                String[] param = config[i].split(":");
                if (!$assertionsDisabled && param.length != 2) {
                    throw new AssertionError();
                }
                try {
                    BeanUtils.getProperty(comp, (String)param[0]);
                    BeanUtils.setProperty(comp, (String)param[0], (Object)param[1]);
                    continue;
                }
                catch (Exception e) {
                    this.log(new StringBuffer().append("Problem with component ").append(config[0]).append(" ").append(e).toString());
                }
            }
            return (T)comp;
        }
        catch (InstantiationException e) {
            this.log(new StringBuffer().append("Problem with component ").append(component).append(" ").append(e).toString());
        }
        catch (IllegalAccessException e) {
            this.log(new StringBuffer().append("Problem with component ").append(component).append(" ").append(e).toString());
        }
        catch (ClassNotFoundException e) {
            this.log(new StringBuffer().append("Problem with component ").append(component).append(" ").append(e).toString());
        }
        this.log(new StringBuffer().append("using default component ").append(defaultcomp).append(" for ").append(component).toString());
        return defaultcomp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$Lanceur == null ? (class$org$sat4j$Lanceur = Lanceur.class$("org.sat4j.Lanceur")) : class$org$sat4j$Lanceur).desiredAssertionStatus();
    }
}

