/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.reader.GoodOPBReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class PBInstanceReader
extends InstanceReader {
    private GoodOPBReader opb;
    private org.sat4j.reader.Reader reader = null;
    private final IPBSolver solver;

    public PBInstanceReader(IPBSolver solver) {
        super((ISolver)solver);
        this.solver = solver;
    }

    private org.sat4j.reader.Reader getDefaultOPBReader() {
        if (this.opb == null) {
            this.opb = new GoodOPBReader(this.solver);
        }
        return this.opb;
    }

    public IProblem parseInstance(String filename) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        String fname;
        boolean isHttp = false;
        String tempFileName = "";
        String prefix = "";
        if (filename.startsWith("http://")) {
            isHttp = true;
            tempFileName = filename;
            filename = filename.substring(filename.lastIndexOf(47), filename.length() - 1);
        }
        if (filename.indexOf(58) != -1) {
            String[] parts = filename.split(":");
            filename = parts[1];
            prefix = parts[0].toUpperCase(Locale.getDefault());
        }
        if (!(fname = filename.endsWith(".gz") ? filename.substring(0, filename.lastIndexOf(46)) : filename).endsWith(".opb") && !"PB".equals(prefix)) {
            return super.parseInstance(filename);
        }
        this.reader = this.getDefaultOPBReader();
        if (isHttp) {
            return this.reader.parseInstance(new URL(tempFileName).openStream());
        }
        return this.reader.parseInstance(filename);
    }

    @Deprecated
    public String decode(int[] model) {
        return this.reader.decode(model);
    }

    public void decode(int[] model, PrintWriter out) {
        this.reader.decode(model, out);
    }

    public IProblem parseInstance(Reader in) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }
}

