/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBReader2005
extends org.sat4j.reader.Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final IPBSolver solver;
    private final IVecInt lits;
    private final IVec<BigInteger> coeffs;
    private BigInteger d;
    private String operator;
    private final IVecInt objectiveVars = new VecInt();
    private final IVec<BigInteger> objectiveCoeffs = new Vec();
    private boolean hasObjFunc = false;
    protected boolean hasVariablesExplanation = false;
    protected int nbVars;
    protected int nbConstr;
    protected int nbConstraintsRead;
    transient BufferedReader in;
    char savedChar;
    boolean charAvailable = false;
    boolean eofReached = false;
    private boolean eolReached = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$reader$OPBReader2005;

    protected void metaData(int nbvar, int nbconstr) {
        this.solver.newVar(nbvar);
    }

    protected void beginObjective() {
    }

    protected void endObjective() {
        if (!$assertionsDisabled && this.lits.size() != this.coeffs.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.lits.size() != this.coeffs.size()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.size(); ++i) {
            this.objectiveVars.push(this.lits.get(i));
            this.objectiveCoeffs.push(this.coeffs.get(i));
        }
    }

    protected void beginConstraint() {
        this.lits.clear();
        this.coeffs.clear();
        if (!$assertionsDisabled && this.lits.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.coeffs.size() != 0) {
            throw new AssertionError();
        }
    }

    protected void endConstraint() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.coeffs.size() == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.lits.size() != this.coeffs.size()) {
            throw new AssertionError();
        }
        if ("<=".equals(this.operator) || "=".equals(this.operator)) {
            this.solver.addPseudoBoolean(this.lits, this.coeffs, false, this.d);
        }
        if (">=".equals(this.operator) || "=".equals(this.operator)) {
            this.solver.addPseudoBoolean(this.lits, this.coeffs, true, this.d);
        }
        ++this.nbConstraintsRead;
    }

    private void constraintTerm(BigInteger coeff, String var) {
        this.coeffs.push((Object)coeff);
        this.lits.push(this.translateVarToId(var));
    }

    protected int translateVarToId(String var) {
        int id = Integer.parseInt(var.substring(1));
        return (this.savedChar == '-' ? -1 : 1) * id;
    }

    protected void constraintRelOp(String relop) {
        this.operator = relop;
    }

    protected void constraintRightTerm(BigInteger val) {
        this.d = val;
    }

    protected char get() throws IOException {
        if (this.charAvailable) {
            this.charAvailable = false;
            return this.savedChar;
        }
        int c = this.in.read();
        if (c == -1) {
            this.eofReached = true;
        }
        this.eolReached = c == 10 || c == 13;
        return (char)c;
    }

    public IVecInt getVars() {
        return this.objectiveVars;
    }

    public IVec<BigInteger> getCoeffs() {
        return this.objectiveCoeffs;
    }

    protected void putback(char c) {
        this.savedChar = c;
        this.charAvailable = true;
    }

    protected boolean eof() {
        return this.eofReached;
    }

    protected boolean eol() {
        return this.eolReached;
    }

    protected void skipSpaces() throws IOException {
        char c;
        while (Character.isWhitespace(c = this.get())) {
        }
        this.putback(c);
    }

    public String readWord() throws IOException {
        char c;
        StringBuffer s = new StringBuffer();
        this.skipSpaces();
        while (!(Character.isWhitespace(c = this.get()) || this.eol() || this.eof())) {
            s.append(c);
        }
        this.putback(c);
        return s.toString();
    }

    public void readInteger(StringBuffer s) throws IOException {
        this.skipSpaces();
        s.setLength(0);
        char c = this.get();
        if (c == '-' || Character.isDigit(c)) {
            s.append(c);
        }
        while (Character.isDigit(c = this.get()) && !this.eol() && !this.eof()) {
            s.append(c);
        }
        this.putback(c);
    }

    protected boolean readIdentifier(StringBuffer s) throws IOException, ParseFormatException {
        block3: {
            s.setLength(0);
            this.skipSpaces();
            char c = this.get();
            if (this.eof()) {
                return false;
            }
            if (!this.isGoodFirstCharacter(c)) {
                this.putback(c);
                return false;
            }
            s.append(c);
            while (true) {
                c = this.get();
                if (this.eof()) break block3;
                if (!this.isGoodFollowingCharacter(c)) break;
                s.append(c);
            }
            this.putback(c);
        }
        this.checkId(s);
        return true;
    }

    protected boolean isGoodFirstCharacter(char c) {
        return Character.isLetter(c) || c == '_';
    }

    protected boolean isGoodFollowingCharacter(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    protected void checkId(StringBuffer s) throws ParseFormatException {
        int varID = Integer.parseInt(s.substring(1));
        if (varID > this.nbVars) {
            throw new ParseFormatException("Variable identifier larger than #variables in metadata.");
        }
    }

    private String readRelOp() throws IOException {
        this.skipSpaces();
        char c = this.get();
        if (this.eof()) {
            return null;
        }
        if (c == '=') {
            return "=";
        }
        char following = this.get();
        if (c == '>' && following == '=') {
            return ">=";
        }
        if (c == '<' && following == '=') {
            return "<=";
        }
        return null;
    }

    protected void readMetaData() throws IOException, ParseFormatException {
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("First line of input file should be a comment");
        }
        String s = this.readWord();
        if (this.eof() || !"#variable=".equals(s)) {
            throw new ParseFormatException("First line should contain #variable= as first keyword");
        }
        this.nbVars = Integer.parseInt(this.readWord());
        s = this.readWord();
        if (this.eof() || !"#constraint=".equals(s)) {
            throw new ParseFormatException("First line should contain #constraint= as second keyword");
        }
        this.nbConstr = Integer.parseInt(this.readWord());
        this.in.readLine();
        this.metaData(this.nbVars, this.nbConstr);
    }

    private void skipComments() throws IOException {
        char c = ' ';
        while (!this.eof() && (c = this.get()) == '*') {
            this.in.readLine();
        }
        this.putback(c);
    }

    protected void readTerm(StringBuffer coeff, StringBuffer var) throws IOException, ParseFormatException, ContradictionException {
        this.readInteger(coeff);
        this.skipSpaces();
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("'*' expected between a coefficient and a variable");
        }
        if (!this.readIdentifier(var)) {
            throw new ParseFormatException("identifier expected");
        }
    }

    protected void readVariablesExplanation() throws IOException, ParseFormatException {
    }

    private void readObjective() throws IOException, ParseFormatException {
        StringBuffer var = new StringBuffer();
        StringBuffer coeff = new StringBuffer();
        this.skipSpaces();
        char c = this.get();
        if (c != 'm') {
            this.putback(c);
            return;
        }
        this.hasObjFunc = true;
        if (this.get() == 'i' && this.get() == 'n' && this.get() == ':') {
            this.beginObjective();
            while (!this.eof()) {
                try {
                    this.readTerm(coeff, var);
                }
                catch (ContradictionException e) {
                    e.printStackTrace();
                }
                this.constraintTerm(new BigInteger(coeff.toString()), var.toString());
                this.skipSpaces();
                c = this.get();
                if (c == ';') break;
                if (c == '-' || c == '+' || Character.isDigit(c)) {
                    this.putback(c);
                    continue;
                }
                throw new ParseFormatException("unexpected character in objective function");
            }
        } else {
            throw new ParseFormatException("input format error: 'min:' expected");
        }
        this.endObjective();
    }

    private void readConstraint() throws IOException, ParseFormatException, ContradictionException {
        char c;
        StringBuffer var = new StringBuffer();
        StringBuffer coeff = new StringBuffer();
        this.beginConstraint();
        while (!this.eof()) {
            this.readTerm(coeff, var);
            this.constraintTerm(new BigInteger(coeff.toString()), var.toString());
            this.skipSpaces();
            c = this.get();
            if (c == '>' || c == '=' || c == '<') {
                this.putback(c);
                break;
            }
            if (c == '-' || c == '+' || Character.isDigit(c)) {
                this.putback(c);
                continue;
            }
            throw new ParseFormatException("unexpected character in constraint");
        }
        if (this.eof()) {
            throw new ParseFormatException("unexpected EOF before end of constraint");
        }
        String relop = this.readRelOp();
        if (relop == null) {
            throw new ParseFormatException("unexpected relational operator in constraint");
        }
        this.constraintRelOp(relop);
        this.readInteger(coeff);
        this.constraintRightTerm(new BigInteger(coeff.toString()));
        this.skipSpaces();
        c = this.get();
        if (this.eof() || c != ';') {
            throw new ParseFormatException("semicolon expected at end of constraint");
        }
        this.endConstraint();
    }

    public OPBReader2005(IPBSolver solver) {
        this.solver = solver;
        this.lits = new VecInt();
        this.coeffs = new Vec();
    }

    public void parse() throws IOException, ParseFormatException, ContradictionException {
        this.readMetaData();
        this.skipComments();
        this.readObjective();
        this.readVariablesExplanation();
        this.nbConstraintsRead = 0;
        while (!this.eof()) {
            this.skipSpaces();
            if (this.eof()) break;
            char c = this.get();
            this.putback(c);
            if (c == '*') {
                this.skipComments();
            }
            if (this.eof()) break;
            this.readConstraint();
        }
        if (this.nbConstraintsRead != this.nbConstr) {
            throw new ParseFormatException("Number of constraints read is different from metadata.");
        }
    }

    public final IProblem parseInstance(Reader in) throws ParseFormatException, ContradictionException {
        IProblem problem = this.parseInstance(new LineNumberReader(in));
        this.solver.setObjectiveFunction(this.getObjectiveFunction());
        return problem;
    }

    private IProblem parseInstance(LineNumberReader in) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        this.in = in;
        try {
            this.parse();
            return this.solver;
        }
        catch (IOException e) {
            throw new ParseFormatException((Throwable)e);
        }
    }

    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < model.length; ++i) {
            if (model[i] < 0) {
                stb.append("-x");
                stb.append(-model[i]);
            } else {
                stb.append("x");
                stb.append(model[i]);
            }
            stb.append(" ");
        }
        return stb.toString();
    }

    public void decode(int[] model, PrintWriter out) {
        for (int i = 0; i < model.length; ++i) {
            if (model[i] < 0) {
                out.print("-x");
                out.print(-model[i]);
            } else {
                out.print("x");
                out.print(model[i]);
            }
            out.print(" ");
        }
    }

    public ObjectiveFunction getObjectiveFunction() {
        if (this.hasObjFunc) {
            return new ObjectiveFunction(this.getVars(), this.getCoeffs());
        }
        return null;
    }

    public IVecInt getListOfVariables() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$reader$OPBReader2005 == null ? (class$org$sat4j$pb$reader$OPBReader2005 = OPBReader2005.class$("org.sat4j.pb.reader.OPBReader2005")) : class$org$sat4j$pb$reader$OPBReader2005).desiredAssertionStatus();
    }
}

