/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class GoodOPBReader
extends org.sat4j.reader.Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMENT_SYMBOL = "*";
    private final IPBSolver solver;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final IVec<String> decode = new Vec();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GoodOPBReader(IPBSolver solver) {
        this.solver = solver;
    }

    public final IProblem parseInstance(Reader in) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(in));
    }

    private IProblem parseInstance(LineNumberReader in) throws ContradictionException, IOException {
        String line;
        this.solver.reset();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).endsWith(";")) {
                line = line.substring(0, line.length() - 1);
            }
            this.parseLine(line);
        }
        return this.solver;
    }

    void parseLine(String line) throws ContradictionException {
        if (line.startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (line.startsWith("p")) {
            return;
        }
        if (line.startsWith("min:") || line.startsWith("min :")) {
            return;
        }
        if (line.startsWith("max:") || line.startsWith("max :")) {
            return;
        }
        int index = line.indexOf(":");
        if (index != -1) {
            line = line.substring(index + 1);
        }
        VecInt lits = new VecInt();
        Vec coeffs = new Vec();
        Scanner stk = new Scanner(line).useDelimiter("\\s*\\*\\s*|\\s*\\+\\s*|\\s+");
        while (stk.hasNext()) {
            BigInteger coef;
            String token = stk.next();
            if (">=".equals(token) || "<=".equals(token) || "=".equals(token)) {
                if (!$assertionsDisabled && !stk.hasNext()) {
                    throw new AssertionError();
                }
                String tok = stk.next();
                if (tok.startsWith("+")) {
                    tok = tok.substring(1);
                }
                BigInteger d = new BigInteger(tok);
                try {
                    if (">=".equals(token) || "=".equals(token)) {
                        this.solver.addPseudoBoolean((IVecInt)lits, (IVec<BigInteger>)coeffs, true, d);
                    }
                    if (!"<=".equals(token) && !"=".equals(token)) continue;
                    this.solver.addPseudoBoolean((IVecInt)lits, (IVec<BigInteger>)coeffs, false, d);
                    continue;
                }
                catch (ContradictionException ce) {
                    System.out.println("c inconsistent constraint: " + line);
                    System.out.println("c lits: " + lits);
                    System.out.println("c coeffs: " + coeffs);
                    throw ce;
                }
            }
            if ("+".equals(token)) {
                if (!$assertionsDisabled && !stk.hasNext()) {
                    throw new AssertionError();
                }
                token = stk.next();
            } else if ("-".equals(token)) {
                if (!$assertionsDisabled && !stk.hasNext()) {
                    throw new AssertionError();
                }
                token = token + stk.next();
            }
            try {
                if (token.startsWith("+")) {
                    token = token.substring(1);
                }
                coef = new BigInteger(token);
                if (!$assertionsDisabled && !stk.hasNext()) {
                    throw new AssertionError();
                }
                token = stk.next();
            }
            catch (NumberFormatException nfe) {
                coef = BigInteger.ONE;
            }
            if ("-".equals(token) || "~".equals(token)) {
                if (!$assertionsDisabled && !stk.hasNext()) {
                    throw new AssertionError();
                }
                token = token + stk.next();
            }
            boolean negative = false;
            if (token.startsWith("+")) {
                token = token.substring(1);
            } else if (token.startsWith("-")) {
                token = token.substring(1);
                if (!$assertionsDisabled && !coef.equals(BigInteger.ONE)) {
                    throw new AssertionError();
                }
                coef = BigInteger.ONE.negate();
            } else if (token.startsWith("~")) {
                token = token.substring(1);
                negative = true;
            }
            Integer id = this.map.get(token);
            if (id == null) {
                id = new Integer(this.decode.size() + 1);
                this.map.put(token, id);
                this.decode.push((Object)token);
            }
            coeffs.push((Object)coef);
            int lid = (negative ? -1 : 1) * id;
            lits.push(lid);
            if (!$assertionsDisabled && coeffs.size() != lits.size()) {
                throw new AssertionError();
            }
        }
    }

    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < model.length; ++i) {
            if (model[i] < 0) {
                stb.append("-");
                stb.append((String)this.decode.get(-model[i] - 1));
            } else {
                stb.append((String)this.decode.get(model[i] - 1));
            }
            stb.append(" ");
        }
        return stb.toString();
    }

    public void decode(int[] model, PrintWriter out) {
        for (int i = 0; i < model.length; ++i) {
            if (model[i] < 0) {
                out.print("-");
                out.print((String)this.decode.get(-model[i] - 1));
            } else {
                out.print((String)this.decode.get(model[i] - 1));
            }
            out.print(" ");
        }
    }

    static {
        $assertionsDisabled = !GoodOPBReader.class.desiredAssertionStatus();
    }
}

