/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.orders;

import java.math.BigInteger;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarOrderHeapObjective
extends VarOrderHeap<ILits> {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction obj;

    public VarOrderHeapObjective() {
        this((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public VarOrderHeapObjective(IPhaseSelectionStrategy strategy) {
        super(strategy);
    }

    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.obj = obj;
    }

    public void init() {
        super.init();
        if (this.obj != null) {
            IVecInt vars = this.obj.getVars();
            IVec<BigInteger> coefs = this.obj.getCoeffs();
            for (int i = 0; i < vars.size(); ++i) {
                int dimacsvar = vars.get(i);
                if (!this.lits.belongsToPool(dimacsvar)) continue;
                int p = this.lits.getFromPool(dimacsvar);
                BigInteger c = (BigInteger)coefs.get(i);
                if (c.signum() < 0) {
                    p = LiteralsUtils.neg((int)p);
                }
                int var = LiteralsUtils.var((int)p);
                this.activity[var] = c.abs().doubleValue();
                if (this.heap.inHeap(var)) {
                    this.heap.increase(var);
                } else {
                    this.heap.insert(var);
                }
                this.phaseStrategy.init(var, LiteralsUtils.neg((int)p));
            }
        }
    }

    public String toString() {
        return new StringBuffer().append(super.toString()).append(" taking into account the objective function").toString();
    }
}

