/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import org.sat4j.core.Vec;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolver;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSolverCP<L extends ILits>
extends PBSolver<L> {
    private static final long serialVersionUID = 1L;
    private IVec<String> conflictVariables = new Vec();
    private IVec<String> conflictConstraints = new Vec();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$core$PBSolverCP;

    public PBSolverCP(AssertingClauseGenerator acg, LearningStrategy<L, PBDataStructureFactory<L>> learner, PBDataStructureFactory<L> dsf, IOrder<L> order) {
        super(acg, learner, dsf, new SearchParams(1.5, 100), order, (RestartStrategy)new MiniSATRestarts());
    }

    public PBSolverCP(AssertingClauseGenerator acg, LearningStrategy<L, PBDataStructureFactory<L>> learner, PBDataStructureFactory<L> dsf, SearchParams params, IOrder<L> order, RestartStrategy restarter) {
        super(acg, learner, dsf, params, order, restarter);
    }

    public PBSolverCP(AssertingClauseGenerator acg, LearningStrategy<L, PBDataStructureFactory<L>> learner, PBDataStructureFactory<L> dsf, SearchParams params, IOrder<L> order) {
        super(acg, learner, dsf, params, order, (RestartStrategy)new MiniSATRestarts());
    }

    public void analyze(Constr myconfl, Pair results) {
        int litImplied = this.trail.last();
        int currentLevel = this.voc.getLevel(litImplied);
        IConflict confl = this.chooseConflict((PBConstr)myconfl, currentLevel);
        this.initExplanation();
        this.buildExplanation(litImplied, myconfl);
        if (!$assertionsDisabled && confl.slackConflict().signum() >= 0) {
            throw new AssertionError();
        }
        while (!confl.isAssertive(currentLevel)) {
            PBConstr constraint = (PBConstr)this.voc.getReason(litImplied);
            this.buildExplanation(litImplied, constraint);
            confl.resolve(constraint, litImplied, (VarActivityListener)this);
            if (!$assertionsDisabled && confl.slackConflict().signum() > 0) {
                throw new AssertionError();
            }
            if (this.trail.size() == 1) break;
            this.undoOne();
            if (this.decisionLevel() == 0) break;
            litImplied = this.trail.last();
            if (this.voc.getLevel(litImplied) != currentLevel) {
                this.trailLim.pop();
                confl.updateSlack(this.voc.getLevel(litImplied));
            }
            if (!$assertionsDisabled && this.voc.getLevel(litImplied) > currentLevel) {
                throw new AssertionError();
            }
            currentLevel = this.voc.getLevel(litImplied);
            if (!$assertionsDisabled && !confl.slackIsCorrect(currentLevel)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && currentLevel != this.decisionLevel()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && litImplied <= 1) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && !confl.isAssertive(currentLevel) && this.trail.size() != 1 && this.decisionLevel() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && currentLevel != this.decisionLevel()) {
            throw new AssertionError();
        }
        this.undoOne();
        if (confl.size() == 0 || (this.decisionLevel() == 0 || this.trail.size() == 0) && confl.slackConflict().signum() < 0) {
            results.reason = null;
            results.backtrackLevel = -1;
            return;
        }
        PBConstr resConstr = (PBConstr)((PBDataStructureFactory)this.dsfactory).createUnregisteredPseudoBooleanConstraint(confl);
        results.reason = resConstr;
        results.backtrackLevel = this.decisionLevel() == 0 || this.trail.size() == 0 ? -1 : confl.getBacktrackLevel(currentLevel);
    }

    protected void analyzeAtRootLevel(Constr myconfl) {
        int litImplied = this.trail.last();
        this.initExplanation();
        this.buildExplanation(litImplied, myconfl);
        while (!this.trail.isEmpty()) {
            PBConstr constraint = (PBConstr)this.voc.getReason(litImplied);
            if (constraint != null) {
                this.buildExplanation(litImplied, constraint);
            }
            this.trail.pop();
            if (this.trail.isEmpty()) continue;
            litImplied = this.trail.last();
        }
    }

    IConflict chooseConflict(PBConstr myconfl, int level) {
        return ConflictMap.createConflict(myconfl, level);
    }

    public String toString(String prefix) {
        return new StringBuffer().append(prefix).append("Cutting planes based inference (").append(this.getClass().getName()).append(")\n").append(super.toString(prefix)).toString();
    }

    void initExplanation() {
        this.conflictVariables.clear();
        this.conflictConstraints.clear();
    }

    void buildExplanation(int lit, Constr c) {
        if (this.listOfVariables != null && this.listOfVariables.contains(lit >> 1)) {
            this.conflictVariables.push((Object)Lits.toString((int)lit));
            this.conflictConstraints.push((Object)c.toString());
        }
    }

    @Override
    public String getExplanation() {
        if (!this.conflictVariables.isEmpty()) {
            if (!$assertionsDisabled && this.conflictVariables.size() != this.conflictConstraints.size()) {
                throw new AssertionError();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Variables and constraints involved in unsatisfiability : \n");
            for (int i = 0; i < this.conflictVariables.size(); ++i) {
                sb.append(new StringBuffer().append("Var : ").append((String)this.conflictVariables.get(i)).toString());
                sb.append(new StringBuffer().append(" - Constr : ").append((String)this.conflictConstraints.get(i)).toString());
                sb.append("\n");
            }
            return sb.toString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$core$PBSolverCP == null ? (class$org$sat4j$pb$core$PBSolverCP = PBSolverCP.class$("org.sat4j.pb.core.PBSolverCP")) : class$org$sat4j$pb$core$PBSolverCP).desiredAssertionStatus();
    }
}

