/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WatchPb
implements PBConstr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean ATMOST = false;
    public static final boolean ATLEAST = true;
    protected double activity;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$pb$WatchPb;

    WatchPb() {
    }

    WatchPb(IDataStructurePB mpb) {
        int size = mpb.size();
        this.lits = new int[size];
        this.coefs = new BigInteger[size];
        mpb.buildConstraintFromMapPb(this.lits, this.coefs);
        this.degree = mpb.getDegree();
        this.sort();
    }

    WatchPb(int[] lits, BigInteger[] coefs, BigInteger degree) {
        this.lits = lits;
        this.coefs = coefs;
        this.degree = degree;
        this.sort();
    }

    public boolean isAssertive(int dl) {
        int i;
        BigInteger slack = BigInteger.ZERO;
        for (i = 0; i < this.lits.length; ++i) {
            if (this.coefs[i].signum() <= 0 || this.voc.isFalsified(this.lits[i]) && this.voc.getLevel(this.lits[i]) < dl) continue;
            slack = slack.add(this.coefs[i]);
        }
        if ((slack = slack.subtract(this.degree)).signum() < 0) {
            return false;
        }
        for (i = 0; i < this.lits.length; ++i) {
            if (this.coefs[i].signum() <= 0 || !this.voc.isUnassigned(this.lits[i]) && this.voc.getLevel(this.lits[i]) < dl || slack.compareTo(this.coefs[i]) >= 0) continue;
            return true;
        }
        return false;
    }

    public void calcReason(int p, IVecInt outReason) {
        for (int q : this.lits) {
            if (!this.voc.isFalsified(q)) continue;
            outReason.push(q ^ 1);
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    public int get(int i) {
        return this.lits[i];
    }

    @Override
    public BigInteger getCoef(int i) {
        return this.coefs[i];
    }

    public double getActivity() {
        return this.activity;
    }

    public static IDataStructurePB niceParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) throws ContradictionException {
        if (ps.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (ps.size() != bigCoefs.size()) {
            throw new IllegalArgumentException(new StringBuffer().append("Contradiction dans la taille des tableaux ps=").append(ps.size()).append(" coefs=").append(bigCoefs.size()).append(".").toString());
        }
        return WatchPb.niceCheckedParameters(ps, bigCoefs, moreThan, bigDeg, voc);
    }

    public static IDataStructurePB niceCheckedParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) {
        if (!($assertionsDisabled || ps.size() != 0 && ps.size() == bigCoefs.size())) {
            throw new AssertionError();
        }
        int[] lits = new int[ps.size()];
        ps.copyTo(lits);
        Object[] bc = new BigInteger[bigCoefs.size()];
        bigCoefs.copyTo(bc);
        BigInteger bigDegree = WatchPb.niceCheckedParametersForCompetition(lits, (BigInteger[])bc, moreThan, bigDeg);
        MapPb mpb = new MapPb(voc.nVars() * 2 + 2);
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.cuttingPlane(lits, (BigInteger[])bc, bigDegree);
        }
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.saturation();
        }
        if (bigDegree.signum() <= 0) {
            return null;
        }
        return mpb;
    }

    public static BigInteger niceParametersForCompetition(int[] ps, BigInteger[] bigCoefs, boolean moreThan, BigInteger bigDeg) throws ContradictionException {
        if (ps.length == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (ps.length != bigCoefs.length) {
            throw new IllegalArgumentException(new StringBuffer().append("Contradiction dans la taille des tableaux ps=").append(ps.length).append(" coefs=").append(bigCoefs.length).append(".").toString());
        }
        return WatchPb.niceCheckedParametersForCompetition(ps, bigCoefs, moreThan, bigDeg);
    }

    public static BigInteger niceCheckedParametersForCompetition(int[] lits, BigInteger[] bc, boolean moreThan, BigInteger bigDeg) {
        int i;
        BigInteger bigDegree = bigDeg;
        if (!moreThan) {
            for (i = 0; i < lits.length; ++i) {
                bc[i] = bc[i].negate();
            }
            bigDegree = bigDegree.negate();
        }
        for (i = 0; i < bc.length; ++i) {
            if (bc[i].signum() >= 0) continue;
            lits[i] = lits[i] ^ 1;
            bc[i] = bc[i].negate();
            bigDegree = bigDegree.add(bc[i]);
        }
        for (i = 0; i < bc.length; ++i) {
            if (bc[i].compareTo(bigDegree) <= 0) continue;
            bc[i] = bigDegree;
        }
        return bigDegree;
    }

    public void incActivity(double claInc) {
        this.activity += claInc;
    }

    public BigInteger slackConstraint() {
        return this.recalcLeftSide().subtract(this.degree);
    }

    public BigInteger slackConstraint(BigInteger[] coefs, BigInteger degree) {
        return this.recalcLeftSide(coefs).subtract(degree);
    }

    public BigInteger recalcLeftSide(BigInteger[] coefs) {
        BigInteger poss = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            if (!$assertionsDisabled && coefs[i].signum() < 0) {
                throw new AssertionError();
            }
            poss = poss.add(coefs[i]);
        }
        return poss;
    }

    public BigInteger recalcLeftSide() {
        return this.recalcLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.recalcLeftSide().compareTo(this.degree) >= 0;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public boolean locked() {
        for (int p : this.lits) {
            if (this.voc.getReason(p) != this) continue;
            return true;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int best_i = i;
            for (int j = i + 1; j < to; ++j) {
                if (this.coefs[j].compareTo(this.coefs[best_i]) <= 0 && (!this.coefs[j].equals(this.coefs[best_i]) || this.lits[j] <= this.lits[best_i])) continue;
                best_i = j;
            }
            BigInteger tmp = this.coefs[i];
            this.coefs[i] = this.coefs[best_i];
            this.coefs[best_i] = tmp;
            int tmp2 = this.lits[i];
            this.lits[i] = this.lits[best_i];
            this.lits[best_i] = tmp2;
        }
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public boolean simplify() {
        BigInteger cumul = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length && cumul.compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            cumul = cumul.add(this.coefs[i]);
        }
        return cumul.compareTo(this.degree) >= 0;
    }

    public int size() {
        return this.lits.length;
    }

    protected final void sort() {
        if (!$assertionsDisabled && this.lits == null) {
            throw new AssertionError();
        }
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
            BigInteger buffInt = this.coefs[0];
            for (int i = 1; i < this.coefs.length; ++i) {
                if (!$assertionsDisabled && buffInt.compareTo(this.coefs[i]) < 0) {
                    throw new AssertionError();
                }
                buffInt = this.coefs[i];
            }
        }
    }

    protected final void sort(int from, int to) {
        int width = to - from;
        if (width <= 15) {
            this.selectionSort(from, to);
        } else {
            int indPivot = width / 2 + from;
            BigInteger pivot = this.coefs[indPivot];
            int litPivot = this.lits[indPivot];
            int i = from - 1;
            int j = to;
            while (true) {
                if (this.coefs[++i].compareTo(pivot) > 0 || this.coefs[i].equals(pivot) && this.lits[i] > litPivot) {
                    continue;
                }
                while (pivot.compareTo(this.coefs[--j]) > 0 || this.coefs[j].equals(pivot) && this.lits[j] < litPivot) {
                }
                if (i >= j) break;
                BigInteger tmp = this.coefs[i];
                this.coefs[i] = this.coefs[j];
                this.coefs[j] = tmp;
                int tmp2 = this.lits[i];
                this.lits[i] = this.lits[j];
                this.lits[j] = tmp2;
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        if (this.lits.length > 0) {
            for (int i = 0; i < this.lits.length; ++i) {
                stb.append(" + ");
                stb.append(this.coefs[i]);
                stb.append(".");
                stb.append(Lits.toString((int)this.lits[i]));
                stb.append("[");
                stb.append(this.voc.valueToString(this.lits[i]));
                stb.append("@");
                stb.append(this.voc.getLevel(this.lits[i]));
                stb.append("]");
                stb.append(" ");
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    public void assertConstraint(UnitPropagationListener s) {
        BigInteger tmp = this.slackConstraint();
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || tmp.compareTo(this.coefs[i]) >= 0) continue;
            boolean ret = s.enqueue(this.lits[i], (Constr)this);
            if (!$assertionsDisabled && !ret) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    public void register() {
        block3: {
            if (!$assertionsDisabled && !this.learnt) {
                throw new AssertionError();
            }
            try {
                this.computeWatches();
            }
            catch (ContradictionException e) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public static IVec<BigInteger> toVecBigInt(IVecInt vec) {
        Vec bigVec = new Vec(vec.size());
        for (int i = 0; i < vec.size(); ++i) {
            bigVec.push((Object)BigInteger.valueOf(vec.get(i)));
        }
        return bigVec;
    }

    public static BigInteger toBigInt(int i) {
        return BigInteger.valueOf(i);
    }

    @Override
    public BigInteger[] getCoefs() {
        BigInteger[] coefsBis = new BigInteger[this.coefs.length];
        System.arraycopy(this.coefs, 0, coefsBis, 0, this.coefs.length);
        return coefsBis;
    }

    @Override
    public int[] getLits() {
        int[] litsBis = new int[this.lits.length];
        System.arraycopy(this.lits, 0, litsBis, 0, this.lits.length);
        return litsBis;
    }

    @Override
    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public IVecInt computeAnImpliedClause() {
        BigInteger cptCoefs = BigInteger.ZERO;
        int index = this.coefs.length;
        while (cptCoefs.compareTo(this.degree) > 0 && index > 0) {
            cptCoefs = cptCoefs.add(this.coefs[--index]);
        }
        if (index > 0 && index < this.size() / 2) {
            VecInt literals = new VecInt(index);
            for (int j = 0; j <= index; ++j) {
                literals.push(this.lits[j]);
            }
            return literals;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }

    public boolean equals(Object pb) {
        if (pb == null) {
            return false;
        }
        try {
            WatchPb wpb = (WatchPb)pb;
            if (!this.degree.equals(wpb.degree) || this.coefs.length != wpb.coefs.length || this.lits.length != wpb.lits.length) {
                return false;
            }
            for (int ilit = 0; ilit < this.coefs.length; ++ilit) {
                int lit = this.lits[ilit];
                boolean ok = false;
                for (int ilit2 = 0; ilit2 < this.coefs.length; ++ilit2) {
                    if (wpb.lits[ilit2] != lit) continue;
                    if (!wpb.coefs[ilit2].equals(this.coefs[ilit])) {
                        return false;
                    }
                    ok = true;
                    break;
                }
                if (ok) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        long sum = 0L;
        for (int p : this.lits) {
            sum += (long)p;
        }
        return (int)sum / this.lits.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$pb$WatchPb == null ? (class$org$sat4j$pb$constraints$pb$WatchPb = WatchPb.class$("org.sat4j.pb.constraints.pb.WatchPb")) : class$org$sat4j$pb$constraints$pb$WatchPb).desiredAssertionStatus();
    }
}

