/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$pb$MinWatchPb;

    protected MinWatchPb(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.watchingCount = 0;
    }

    protected MinWatchPb(ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) {
        super(lits, coefs, degree);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.watchingCount = 0;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul.signum() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount != 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.length && this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watch(this.lits[i] ^ 1, (Propagatable)this);
            this.watching[this.watchingCount++] = i;
            this.watched[i] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[i]);
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    private void watchMoreForLearntConstraint() {
        int free = 1;
        while (this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0 && free > 0) {
            free = 0;
            int maxlevel = -1;
            int maxi = -1;
            for (int i = 0; i < this.lits.length; ++i) {
                if (!this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                ++free;
                int level = this.voc.getLevel(this.lits[i]);
                if (level <= maxlevel) continue;
                maxi = i;
                maxlevel = level;
            }
            if (free <= 0) continue;
            if (!$assertionsDisabled && maxi < 0) {
                throw new AssertionError();
            }
            this.voc.watch(this.lits[maxi] ^ 1, (Propagatable)this);
            this.watching[this.watchingCount++] = maxi;
            this.watched[maxi] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[maxi]);
            if (!$assertionsDisabled && --free < 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.lits.length != 1 && this.watchingCount <= 1) {
            throw new AssertionError();
        }
    }

    @Override
    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        for (int ind = 0; ind < this.lits.length && this.watchCumul.subtract(this.coefs[this.watching[ind]]).compareTo(this.degree) < 0; ++ind) {
            if (!this.voc.isUnassigned(this.lits[ind]) || s.enqueue(this.lits[ind], (Constr)this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return MinWatchPb.minWatchPbNew(s, voc, ps, MinWatchPb.toVecBigInt(coefs), moreThan, MinWatchPb.toBigInt(degree));
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        VecInt litsVec = new VecInt(ps.size());
        Vec coefsVec = new Vec(coefs.size());
        ps.copyTo((IVecInt)litsVec);
        coefs.copyTo((IVec)coefsVec);
        IDataStructurePB mpb = MinWatchPb.niceParameters((IVecInt)litsVec, (IVec<BigInteger>)coefsVec, moreThan, degree, voc);
        if (mpb == null) {
            return null;
        }
        MinWatchPb outclause = new MinWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static MinWatchPb normalizedMinWatchPbNew(UnitPropagationListener s, ILits voc, IDataStructurePB mpb) throws ContradictionException {
        MinWatchPb outclause = new MinWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static MinWatchPb normalizedMinWatchPbNew(UnitPropagationListener s, ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        MinWatchPb outclause = new MinWatchPb(voc, lits, coefs, degree);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    protected int nbOfWatched() {
        int retour = 0;
        for (int ind = 0; ind < this.watched.length; ++ind) {
            for (int i = 0; i < this.watchingCount; ++i) {
                if (this.watching[i] == ind && !$assertionsDisabled && !this.watched[ind]) {
                    throw new AssertionError();
                }
            }
            retour += this.watched[ind] ? 1 : 0;
        }
        return retour;
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        int pIndiceWatching;
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount <= 1) {
            throw new AssertionError();
        }
        for (pIndiceWatching = 0; pIndiceWatching < this.watchingCount && (this.lits[this.watching[pIndiceWatching]] ^ 1) != p; ++pIndiceWatching) {
        }
        int pIndice = this.watching[pIndiceWatching];
        if (!$assertionsDisabled && p != (this.lits[pIndice] ^ 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.watched[pIndice]) {
            throw new AssertionError();
        }
        BigInteger maxCoef = this.maximalCoefficient(pIndice);
        maxCoef = this.updateWatched(maxCoef, pIndice);
        BigInteger upWatchCumul = this.watchCumul.subtract(this.coefs[pIndice]);
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (upWatchCumul.compareTo(this.degree) < 0) {
            this.voc.watch(p, (Propagatable)this);
            if (!$assertionsDisabled && !this.watched[pIndice]) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (upWatchCumul.compareTo(this.degree.add(maxCoef)) < 0) {
            if (!$assertionsDisabled && this.watchingCount == 0) {
                throw new AssertionError();
            }
            BigInteger limit = upWatchCumul.subtract(this.degree);
            for (int i = 0; i < this.watchingCount; ++i) {
                if (limit.compareTo(this.coefs[this.watching[i]]) >= 0 || i == pIndiceWatching || this.voc.isSatisfied(this.lits[this.watching[i]]) || s.enqueue(this.lits[this.watching[i]], (Constr)this)) continue;
                this.voc.watch(p, (Propagatable)this);
                if (!$assertionsDisabled && this.isSatisfiable()) {
                    throw new AssertionError();
                }
                return false;
            }
            this.voc.undos(p).push((Object)this);
        }
        this.watched[pIndice] = false;
        this.watchCumul = upWatchCumul;
        this.watching[pIndiceWatching] = this.watching[--this.watchingCount];
        if (!$assertionsDisabled && this.watchingCount == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove() {
        for (int i = 0; i < this.watchingCount; ++i) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove((Object)this);
            this.watched[this.watching[i]] = false;
        }
        this.watchingCount = 0;
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    public void undo(int p) {
        this.voc.watch(p, (Propagatable)this);
        int pIndice = 0;
        while ((this.lits[pIndice] ^ 1) != p) {
            ++pIndice;
        }
        if (!$assertionsDisabled && pIndice >= this.lits.length) {
            throw new AssertionError();
        }
        this.watchCumul = this.watchCumul.add(this.coefs[pIndice]);
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
        this.watched[pIndice] = true;
        this.watching[this.watchingCount++] = pIndice;
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVecInt coefs, boolean moreThan, int degree) {
        return MinWatchPb.watchPbNew(voc, lits, MinWatchPb.toVecBigInt(coefs), moreThan, MinWatchPb.toBigInt(degree));
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) {
        IDataStructurePB mpb = null;
        mpb = MinWatchPb.niceCheckedParameters(lits, coefs, moreThan, degree, voc);
        return new MinWatchPb(voc, mpb);
    }

    public static WatchPb normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new MinWatchPb(voc, mpb);
    }

    protected BigInteger maximalCoefficient(int pIndice) {
        BigInteger maxCoef = BigInteger.ZERO;
        for (int i = 0; i < this.watchingCount; ++i) {
            if (this.coefs[this.watching[i]].compareTo(maxCoef) <= 0 || this.watching[i] == pIndice) continue;
            maxCoef = this.coefs[this.watching[i]];
        }
        if (!$assertionsDisabled && !this.learnt && maxCoef.signum() == 0) {
            throw new AssertionError();
        }
        return maxCoef;
    }

    protected BigInteger updateWatched(BigInteger mc, int pIndice) {
        BigInteger maxCoef = mc;
        if (this.watchingCount < this.size()) {
            BigInteger upWatchCumul = this.watchCumul.subtract(this.coefs[pIndice]);
            BigInteger degreePlusMaxCoef = this.degree.add(maxCoef);
            for (int ind = 0; ind < this.lits.length && upWatchCumul.compareTo(degreePlusMaxCoef) < 0; ++ind) {
                if (this.voc.isFalsified(this.lits[ind]) || this.watched[ind]) continue;
                upWatchCumul = upWatchCumul.add(this.coefs[ind]);
                this.watched[ind] = true;
                if (!$assertionsDisabled && this.watchingCount >= this.size()) {
                    throw new AssertionError();
                }
                this.watching[this.watchingCount++] = ind;
                this.voc.watch(this.lits[ind] ^ 1, (Propagatable)this);
                if (this.coefs[ind].compareTo(maxCoef) <= 0) continue;
                maxCoef = this.coefs[ind];
                degreePlusMaxCoef = this.degree.add(maxCoef);
            }
            this.watchCumul = upWatchCumul.add(this.coefs[pIndice]);
        }
        return maxCoef;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$pb$MinWatchPb == null ? (class$org$sat4j$pb$constraints$pb$MinWatchPb = MinWatchPb.class$("org.sat4j.pb.constraints.pb.MinWatchPb")) : class$org$sat4j$pb$constraints$pb$MinWatchPb).desiredAssertionStatus();
    }
}

