/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$pb$MaxWatchPb;

    private MaxWatchPb(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
    }

    private MaxWatchPb(ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) {
        super(lits, coefs, degree);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && !this.watchCumul.equals(BigInteger.ZERO)) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (!this.learnt) continue;
                this.voc.undos(this.lits[i] ^ 1).push((Object)this);
                this.voc.watch(this.lits[i] ^ 1, (Propagatable)this);
                continue;
            }
            this.voc.watch(this.lits[i] ^ 1, (Propagatable)this);
            this.watchCumul = this.watchCumul.add(this.coefs[i]);
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    @Override
    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        for (int ind = 0; ind < this.coefs.length && this.watchCumul.subtract(this.coefs[ind]).compareTo(this.degree) < 0; ++ind) {
            if (!this.voc.isUnassigned(this.lits[ind]) || s.enqueue(this.lits[ind], (Constr)this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return MaxWatchPb.maxWatchPbNew(s, voc, ps, MaxWatchPb.toVecBigInt(coefs), moreThan, MaxWatchPb.toBigInt(degree));
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        VecInt litsVec = new VecInt();
        Vec coefsVec = new Vec();
        ps.copyTo((IVecInt)litsVec);
        coefs.copyTo((IVec)coefsVec);
        IDataStructurePB mpb = MaxWatchPb.niceParameters((IVecInt)litsVec, (IVec<BigInteger>)coefsVec, moreThan, degree, voc);
        if (mpb == null) {
            return null;
        }
        MaxWatchPb outclause = new MaxWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.watch(p, (Propagatable)this);
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError((Object)new StringBuffer().append("").append(this.watchCumul).append("/").append(this.recalcLeftSide()).append(":").append(this.learnt).toString());
        }
        int indiceP = 0;
        while ((this.lits[indiceP] ^ 1) != p) {
            ++indiceP;
        }
        BigInteger coefP = this.coefs[indiceP];
        BigInteger newcumul = this.watchCumul.subtract(coefP);
        if (newcumul.compareTo(this.degree) < 0) {
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        this.voc.undos(p).push((Object)this);
        this.watchCumul = newcumul;
        BigInteger limit = this.watchCumul.subtract(this.degree);
        for (int ind = 0; ind < this.coefs.length && limit.compareTo(this.coefs[ind]) < 0; ++ind) {
            if (!this.voc.isUnassigned(this.lits[ind]) || s.enqueue(this.lits[ind], (Constr)this)) continue;
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (!$assertionsDisabled && !this.learnt && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watches(this.lits[i] ^ 1).remove((Object)this);
        }
    }

    public void undo(int p) {
        int indiceP = 0;
        while ((this.lits[indiceP] ^ 1) != p) {
            ++indiceP;
        }
        if (!$assertionsDisabled && this.coefs[indiceP].signum() <= 0) {
            throw new AssertionError();
        }
        this.watchCumul = this.watchCumul.add(this.coefs[indiceP]);
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVecInt coefs, boolean moreThan, int degree) {
        return MaxWatchPb.watchPbNew(voc, lits, MaxWatchPb.toVecBigInt(coefs), moreThan, MaxWatchPb.toBigInt(degree));
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) {
        IDataStructurePB mpb = null;
        mpb = MaxWatchPb.niceCheckedParameters(lits, coefs, moreThan, degree, voc);
        return new MaxWatchPb(voc, mpb);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener s, ILits voc, IDataStructurePB mpb) throws ContradictionException {
        MaxWatchPb outclause = new MaxWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener s, ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        MaxWatchPb outclause = new MaxWatchPb(voc, lits, coefs, degree);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static WatchPb normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new MaxWatchPb(voc, mpb);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$pb$MaxWatchPb == null ? (class$org$sat4j$pb$constraints$pb$MaxWatchPb = MaxWatchPb.class$("org.sat4j.pb.constraints.pb.MaxWatchPb")) : class$org$sat4j$pb$constraints$pb$MaxWatchPb).desiredAssertionStatus();
    }
}

