/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.InternalMapPBStructure;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPb
implements IDataStructurePB {
    protected InternalMapPBStructure weightedLits;
    protected BigInteger degree;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$pb$MapPb;

    MapPb(PBConstr cpb) {
        this.weightedLits = new InternalMapPBStructure(cpb);
        this.degree = cpb.getDegree();
    }

    MapPb(int size) {
        this.weightedLits = new InternalMapPBStructure(size);
        this.degree = BigInteger.ZERO;
    }

    @Override
    public boolean isCardinality() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.weightedLits.getCoef(i).equals(BigInteger.ONE)) continue;
            return false;
        }
        return true;
    }

    @Override
    public BigInteger saturation() {
        int ind;
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        BigInteger minimum = this.degree;
        for (ind = 0; ind < this.size(); ++ind) {
            if (!$assertionsDisabled && this.weightedLits.getCoef(ind).signum() <= 0) {
                throw new AssertionError();
            }
            if (this.degree.compareTo(this.weightedLits.getCoef(ind)) < 0) {
                this.changeCoef(ind, this.degree);
            }
            if (!$assertionsDisabled && this.weightedLits.getCoef(ind).signum() <= 0) {
                throw new AssertionError();
            }
            minimum = minimum.min(this.weightedLits.getCoef(ind));
        }
        if (minimum.equals(this.degree) && minimum.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            for (ind = 0; ind < this.size(); ++ind) {
                this.changeCoef(ind, BigInteger.ONE);
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger deg, BigInteger[] reducedCoefs, VarActivityListener val) {
        return this.cuttingPlane(cpb, deg, reducedCoefs, BigInteger.ONE, val);
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger degreeCons, BigInteger[] reducedCoefs, BigInteger coefMult, VarActivityListener val) {
        this.degree = this.degree.add(degreeCons);
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        if (reducedCoefs == null) {
            for (int i = 0; i < cpb.size(); ++i) {
                val.varBumpActivity(cpb.get(i));
                this.cuttingPlaneStep(cpb.get(i), this.multiplyCoefficient(cpb.getCoef(i), coefMult));
            }
        } else {
            for (int i = 0; i < cpb.size(); ++i) {
                val.varBumpActivity(cpb.get(i));
                this.cuttingPlaneStep(cpb.get(i), this.multiplyCoefficient(reducedCoefs[i], coefMult));
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger deg) {
        return this.cuttingPlane(lits, reducedCoefs, deg, BigInteger.ONE);
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger degreeCons, BigInteger coefMult) {
        this.degree = this.degree.add(degreeCons);
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < lits.length; ++i) {
            this.cuttingPlaneStep(lits[i], reducedCoefs[i].multiply(coefMult));
        }
        return this.degree;
    }

    private void cuttingPlaneStep(int lit, BigInteger coef) {
        if (!$assertionsDisabled && coef.signum() < 0) {
            throw new AssertionError();
        }
        int nlit = lit ^ 1;
        if (coef.signum() > 0) {
            if (this.weightedLits.containsKey(nlit)) {
                if (!$assertionsDisabled && this.weightedLits.containsKey(lit)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.weightedLits.get(nlit) == null) {
                    throw new AssertionError();
                }
                if (this.weightedLits.get(nlit).compareTo(coef) < 0) {
                    BigInteger tmp = this.weightedLits.get(nlit);
                    this.setCoef(lit, coef.subtract(tmp));
                    if (!$assertionsDisabled && this.weightedLits.get(lit).signum() <= 0) {
                        throw new AssertionError();
                    }
                    this.degree = this.degree.subtract(tmp);
                    this.removeCoef(nlit);
                } else if (this.weightedLits.get(nlit).equals(coef)) {
                    this.degree = this.degree.subtract(coef);
                    this.removeCoef(nlit);
                } else {
                    this.decreaseCoef(nlit, coef);
                    if (!$assertionsDisabled && this.weightedLits.get(nlit).signum() <= 0) {
                        throw new AssertionError();
                    }
                    this.degree = this.degree.subtract(coef);
                }
            } else {
                if (!$assertionsDisabled && this.weightedLits.containsKey(lit) && this.weightedLits.get(lit).signum() <= 0) {
                    throw new AssertionError();
                }
                if (this.weightedLits.containsKey(lit)) {
                    this.increaseCoef(lit, coef);
                } else {
                    this.setCoef(lit, coef);
                }
                if (!$assertionsDisabled && this.weightedLits.get(lit).signum() <= 0) {
                    throw new AssertionError();
                }
            }
        }
        if (!$assertionsDisabled && this.weightedLits.containsKey(nlit) && this.weightedLits.containsKey(lit)) {
            throw new AssertionError();
        }
    }

    @Override
    public void buildConstraintFromConflict(IVecInt resLits, IVec<BigInteger> resCoefs) {
        resLits.clear();
        resCoefs.clear();
        this.weightedLits.copyCoefs(resCoefs);
        this.weightedLits.copyLits(resLits);
    }

    @Override
    public void buildConstraintFromMapPb(int[] resLits, BigInteger[] resCoefs) {
        if (!$assertionsDisabled && resLits.length != resCoefs.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resLits.length != this.size()) {
            throw new AssertionError();
        }
        this.weightedLits.copyCoefs(resCoefs);
        this.weightedLits.copyLits(resLits);
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public int size() {
        return this.weightedLits.size();
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int ind = 0; ind < this.size(); ++ind) {
            stb.append(this.weightedLits.getCoef(ind));
            stb.append(".");
            stb.append(Lits.toString((int)this.weightedLits.getLit(ind)));
            stb.append(" ");
        }
        return new StringBuffer().append(stb.toString()).append(" >= ").append(this.degree).toString();
    }

    private BigInteger multiplyCoefficient(BigInteger coef, BigInteger mult) {
        if (coef.equals(BigInteger.ONE)) {
            return mult;
        }
        return coef.multiply(mult);
    }

    void increaseCoef(int lit, BigInteger incCoef) {
        this.weightedLits.put(lit, this.weightedLits.get(lit).add(incCoef));
    }

    void decreaseCoef(int lit, BigInteger decCoef) {
        this.weightedLits.put(lit, this.weightedLits.get(lit).subtract(decCoef));
    }

    void setCoef(int lit, BigInteger newValue) {
        this.weightedLits.put(lit, newValue);
    }

    void changeCoef(int indLit, BigInteger newValue) {
        this.weightedLits.changeCoef(indLit, newValue);
    }

    void removeCoef(int lit) {
        this.weightedLits.remove(lit);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$pb$MapPb == null ? (class$org$sat4j$pb$constraints$pb$MapPb = MapPb.class$("org.sat4j.pb.constraints.pb.MapPb")) : class$org$sat4j$pb$constraints$pb$MapPb).desiredAssertionStatus();
    }
}

