/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalMapPBStructure {
    IVecInt lits;
    IVec<BigInteger> coefs;
    IVecInt allLits;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$pb$InternalMapPBStructure;

    InternalMapPBStructure(int size) {
        if (!$assertionsDisabled && size <= 0) {
            throw new AssertionError();
        }
        this.allLits = new VecInt(size, -1);
        this.coefs = new Vec();
        this.lits = new VecInt();
    }

    InternalMapPBStructure(PBConstr cpb) {
        this.allLits = new VecInt(cpb.getVocabulary().nVars() * 2 + 2, -1);
        this.coefs = new Vec(cpb.size());
        this.lits = new VecInt(cpb.size());
        for (int i = 0; i < cpb.size(); ++i) {
            if (!$assertionsDisabled && cpb.get(i) == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && cpb.getCoef(i).signum() <= 0) {
                throw new AssertionError();
            }
            int lit = cpb.get(i);
            this.lits.push(lit);
            if (!$assertionsDisabled && i + 1 != this.lits.size()) {
                throw new AssertionError();
            }
            this.allLits.set(lit, i);
            this.coefs.push((Object)cpb.getCoef(i));
        }
    }

    BigInteger get(int lit) {
        if (!$assertionsDisabled && this.allLits.get(lit) == -1) {
            throw new AssertionError();
        }
        return (BigInteger)this.coefs.get(this.allLits.get(lit));
    }

    int getLit(int indLit) {
        if (!$assertionsDisabled && indLit >= this.lits.size()) {
            throw new AssertionError();
        }
        return this.lits.get(indLit);
    }

    BigInteger getCoef(int indLit) {
        if (!$assertionsDisabled && indLit >= this.coefs.size()) {
            throw new AssertionError();
        }
        return (BigInteger)this.coefs.get(indLit);
    }

    boolean containsKey(int lit) {
        return this.allLits.get(lit) != -1;
    }

    int size() {
        return this.lits.size();
    }

    void put(int lit, BigInteger newValue) {
        int indLit = this.allLits.get(lit);
        if (indLit != -1) {
            this.coefs.set(indLit, (Object)newValue);
        } else {
            this.lits.push(lit);
            this.coefs.push((Object)newValue);
            this.allLits.set(lit, this.lits.size() - 1);
        }
    }

    void changeCoef(int indLit, BigInteger newValue) {
        if (!$assertionsDisabled && indLit > this.coefs.size()) {
            throw new AssertionError();
        }
        this.coefs.set(indLit, (Object)newValue);
    }

    void remove(int lit) {
        int indLit = this.allLits.get(lit);
        if (indLit != -1) {
            int tmp = this.lits.last();
            this.coefs.delete(indLit);
            this.lits.delete(indLit);
            this.allLits.set(tmp, indLit);
            this.allLits.set(lit, -1);
        }
    }

    void copyCoefs(IVec<BigInteger> dest) {
        this.coefs.copyTo(dest);
    }

    void copyCoefs(BigInteger[] dest) {
        this.coefs.copyTo((Object[])dest);
    }

    void copyLits(IVecInt dest) {
        this.lits.copyTo(dest);
    }

    void copyLits(int[] dest) {
        this.lits.copyTo(dest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$pb$InternalMapPBStructure == null ? (class$org$sat4j$pb$constraints$pb$InternalMapPBStructure = InternalMapPBStructure.class$("org.sat4j.pb.constraints.pb.InternalMapPBStructure")) : class$org$sat4j$pb$constraints$pb$InternalMapPBStructure).desiredAssertionStatus();
    }
}

