/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchCardPB;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.PuebloMinWatchPb;
import org.sat4j.pb.constraints.pb.WLClausePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuebloPBMinClauseCardConstrDataStructure
extends AbstractPBClauseCardConstrDataStructure {
    private static final long serialVersionUID = 1L;

    @Override
    protected PBConstr constructClause(IVecInt v) {
        return WLClausePB.brandNewClause(this.solver, this.getVocabulary(), v);
    }

    @Override
    protected PBConstr constructCard(IVecInt lits, int degree) throws ContradictionException {
        return MinWatchCardPB.normalizedMinWatchCardPBNew(this.solver, this.getVocabulary(), lits, degree);
    }

    @Override
    protected PBConstr constructPB(IDataStructurePB mpb) throws ContradictionException {
        return MinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), mpb);
    }

    @Override
    protected PBConstr constructPB(int[] lits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        return MinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), lits, coefs, degree);
    }

    @Override
    protected PBConstr constructLearntClause(IVecInt literals) {
        return new WLClausePB(literals, this.getVocabulary());
    }

    @Override
    protected PBConstr constructLearntCard(IVecInt literals, int degree) {
        return new MinWatchCardPB(this.getVocabulary(), literals, true, degree);
    }

    @Override
    protected PBConstr constructLearntPB(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return PuebloMinWatchPb.watchPbNew(this.getVocabulary(), literals, coefs, true, degree);
    }

    @Override
    protected PBConstr constructLearntClause(IDataStructurePB dspb) {
        VecInt resLits = new VecInt();
        Vec resCoefs = new Vec();
        dspb.buildConstraintFromConflict((IVecInt)resLits, (IVec<BigInteger>)resCoefs);
        return new WLClausePB((IVecInt)resLits, this.getVocabulary());
    }

    @Override
    protected PBConstr constructLearntCard(IDataStructurePB dspb) {
        VecInt resLits = new VecInt();
        Vec resCoefs = new Vec();
        dspb.buildConstraintFromConflict((IVecInt)resLits, (IVec<BigInteger>)resCoefs);
        return new MinWatchCardPB(this.getVocabulary(), (IVecInt)resLits, true, dspb.getDegree().intValue());
    }

    @Override
    protected PBConstr constructLearntPB(IDataStructurePB dspb) {
        return PuebloMinWatchPb.normalizedWatchPbNew(this.getVocabulary(), dspb);
    }
}

