/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.LearntWLClause;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.AtLeastPB;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.IInternalPBConstraintCreator;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.WLClausePB;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBDataStructureFactory
extends AbstractDataStructureFactory<ILits>
implements PBDataStructureFactory<ILits>,
IInternalPBConstraintCreator {
    private static final long serialVersionUID = 1L;

    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = WLClause.sanityCheck((IVecInt)literals, (ILits)this.getVocabulary(), (UnitPropagationListener)this.solver);
        if (v == null) {
            return null;
        }
        return WLClausePB.brandNewClause(this.solver, this.getVocabulary(), v);
    }

    public Constr createUnregisteredClause(IVecInt literals) {
        return new LearntWLClause(literals, this.getVocabulary());
    }

    public Constr createCardinalityConstraint(IVecInt literals, int degree) throws ContradictionException {
        return AtLeastPB.atLeastNew(this.solver, this.getVocabulary(), literals, degree);
    }

    @Override
    public Constr createPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        return this.constraintFactory(literals, coefs, moreThan, degree);
    }

    protected abstract PBConstr constraintFactory(IVecInt var1, IVecInt var2, boolean var3, int var4) throws ContradictionException;

    protected abstract PBConstr constraintFactory(IDataStructurePB var1);

    protected abstract PBConstr constraintFactory(IVecInt var1, IVec<BigInteger> var2, boolean var3, BigInteger var4) throws ContradictionException;

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.constraintFactory(literals, coefs, degree);
    }

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IDataStructurePB dspb) {
        return this.constraintFactory(dspb);
    }

    public IConstr createUnregisteredPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        return this.constraintFactory(literals, coefs, moreThan, degree);
    }

    protected abstract PBConstr constraintFactory(IVecInt var1, IVecInt var2, int var3);

    protected abstract PBConstr constraintFactory(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);

    protected ILits createLits() {
        return new Lits();
    }

    public /* synthetic */ IConstr createUnregisteredPseudoBooleanConstraint(IVecInt x0, IVec x1, BigInteger x2) {
        return this.createUnregisteredPseudoBooleanConstraint(x0, (IVec<BigInteger>)x1, x2);
    }
}

