/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;
    static final BigInteger MAX_INT_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructure;

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return this.constraintFactory(literals, WatchPb.toVecBigInt(coefs), moreThan, WatchPb.toBigInt(degree));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVecInt coefs, int degree) {
        return this.constraintFactory(literals, WatchPb.toVecBigInt(coefs), WatchPb.toBigInt(degree));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IDataStructurePB mpb = WatchPb.niceParameters(literals, coefs, moreThan, degree, this.getVocabulary());
        if (mpb == null) {
            return null;
        }
        int size = mpb.size();
        int[] lits = new int[size];
        Object[] normCoefs = new BigInteger[size];
        mpb.buildConstraintFromMapPb(lits, (BigInteger[])normCoefs);
        if (mpb.getDegree().equals(BigInteger.ONE)) {
            IVecInt v = WLClause.sanityCheck((IVecInt)new VecInt(lits), (ILits)this.getVocabulary(), (UnitPropagationListener)this.solver);
            if (v == null) {
                return null;
            }
            return this.constructClause(v);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne((IVec<BigInteger>)new Vec(normCoefs))) {
            if (!$assertionsDisabled && mpb.getDegree().compareTo(MAX_INT_VALUE) >= 0) {
                throw new AssertionError();
            }
            return this.constructCard((IVecInt)new VecInt(lits), mpb.getDegree().intValue());
        }
        return this.constructPB(lits, (BigInteger[])normCoefs, mpb.getDegree());
    }

    @Override
    protected PBConstr constraintFactory(IDataStructurePB dspb) {
        if (dspb.getDegree().equals(BigInteger.ONE)) {
            return this.constructLearntClause(dspb);
        }
        if (dspb.isCardinality()) {
            return this.constructLearntCard(dspb);
        }
        return this.constructLearntPB(dspb);
    }

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        if (degree.equals(BigInteger.ONE)) {
            return this.constructLearntClause(literals);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(coefs)) {
            return this.constructLearntCard(literals, degree.intValue());
        }
        return this.constructLearntPB(literals, coefs, degree);
    }

    static boolean coefficientsEqualToOne(IVec<BigInteger> coeffs) {
        for (int i = 0; i < coeffs.size(); ++i) {
            if (((BigInteger)coeffs.get(i)).equals(BigInteger.ONE)) continue;
            return false;
        }
        return true;
    }

    protected abstract PBConstr constructClause(IVecInt var1);

    protected abstract PBConstr constructCard(IVecInt var1, int var2) throws ContradictionException;

    protected abstract PBConstr constructPB(IDataStructurePB var1) throws ContradictionException;

    protected abstract PBConstr constructPB(int[] var1, BigInteger[] var2, BigInteger var3) throws ContradictionException;

    protected abstract PBConstr constructLearntClause(IVecInt var1);

    protected abstract PBConstr constructLearntCard(IVecInt var1, int var2);

    protected abstract PBConstr constructLearntPB(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);

    protected abstract PBConstr constructLearntClause(IDataStructurePB var1);

    protected abstract PBConstr constructLearntCard(IDataStructurePB var1);

    protected abstract PBConstr constructLearntPB(IDataStructurePB var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructure == null ? (class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructure = AbstractPBClauseCardConstrDataStructure.class$("org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure")) : class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructure).desiredAssertionStatus();
        MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    }
}

