/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private int[] prevmodel;
    private boolean[] prevfullmodel;

    public PseudoOptDecorator(IPBSolver solver) {
        super(solver);
    }

    public void setObjectiveFunction(ObjectiveFunction objf) {
        this.objfct = objf;
        ((IPBSolver)this.decorated()).setObjectiveFunction(objf);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean result = super.isSatisfiable(true);
        if (result) {
            this.prevmodel = super.model();
            this.prevfullmodel = new boolean[this.nVars()];
            for (int i = 0; i < this.nVars(); ++i) {
                this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
            }
        }
        return result;
    }

    public boolean hasNoObjectiveFunction() {
        return this.objfct == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        return this.objfct.calculateDegree(this.prevmodel);
    }

    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, this.objfct.calculateDegree(this.prevmodel).subtract(BigInteger.ONE));
    }

    public int[] model() {
        return this.prevmodel;
    }

    public boolean model(int var) {
        return this.prevfullmodel[var - 1];
    }

    public String toString(String prefix) {
        return prefix + "Pseudo Boolean Optimization\n" + super.toString(prefix);
    }
}

