/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.ReadOnlyVec;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;

    public ObjectiveFunction(IVecInt vars, IVec<BigInteger> coeffs) {
        this.vars = new ReadOnlyVecInt(vars);
        this.coeffs = new ReadOnlyVec(coeffs);
    }

    public BigInteger calculateDegree(int[] model) {
        BigInteger tempDegree = BigInteger.ZERO;
        for (int i = 0; i < this.vars.size(); ++i) {
            BigInteger coeff = (BigInteger)this.coeffs.get(i);
            if (this.varInModel(this.vars.get(i), model)) {
                tempDegree = tempDegree.add(coeff);
                continue;
            }
            if (coeff.signum() >= 0 || this.varInModel(-this.vars.get(i), model)) continue;
            tempDegree = tempDegree.add(coeff);
        }
        return tempDegree;
    }

    private boolean varInModel(int var, int[] model) {
        for (int i = 0; i < model.length; ++i) {
            if (var != model[i]) continue;
            return true;
        }
        return false;
    }

    public IVec<BigInteger> getCoeffs() {
        return this.coeffs;
    }

    public IVecInt getVars() {
        return this.vars;
    }
}

