/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$OPBStringSolver;

    public OPBStringSolver() {
    }

    public OPBStringSolver(int initSize) {
        super(initSize);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        StringBuffer out = this.getOut();
        if (!$assertionsDisabled && lits.size() != coeffs.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        if (moreThan) {
            for (int i = 0; i < lits.size(); ++i) {
                out.append(new StringBuffer().append(coeffs.get(i)).append(" x").append(lits.get(i)).append(" ").toString());
            }
            out.append(new StringBuffer().append(">= ").append(d).append(" ;\n").toString());
        } else {
            for (int i = 0; i < lits.size(); ++i) {
                out.append(new StringBuffer().append(((BigInteger)coeffs.get(i)).negate()).append(" x").append(lits.get(i)).append(" ").toString());
            }
            out.append(new StringBuffer().append(">= ").append(d.negate()).append(" ;\n").toString());
        }
        return null;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        StringBuffer out = this.getOut();
        StringBuffer tmp = new StringBuffer();
        tmp.append(new StringBuffer().append(" #constraint= ").append(this.nbOfConstraints).append(" \n").toString());
        tmp.append("min : ");
        IVecInt lits = obj.getVars();
        IVec<BigInteger> coeffs = obj.getCoeffs();
        for (int i = 0; i < lits.size(); ++i) {
            tmp.append(new StringBuffer().append(coeffs.get(i)).append(" x").append(lits.get(i)).append(" ").toString());
        }
        tmp.append(" ;\n");
        out.insert(this.indxConstrObj, tmp);
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            out.append(new StringBuffer().append("+1 x").append(iterator.next()).append(" ").toString());
        }
        out.append(new StringBuffer().append(">= ").append(degree).append(" ;\n").toString());
        return null;
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            out.append(new StringBuffer().append("-1 x").append(iterator.next()).append(" ").toString());
        }
        out.append(new StringBuffer().append(">= ").append(-degree).append(" ;\n").toString());
        return null;
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            out.append(new StringBuffer().append("+1 x").append(iterator.next()).append(" ").toString());
        }
        out.append(">= 1 ;\n");
        return null;
    }

    @Override
    public String getExplanation() {
        return null;
    }

    @Override
    public void setListOfVariablesForExplanation(IVecInt listOfVariables) {
    }

    public String toString() {
        return this.getOut().toString();
    }

    public String toString(String prefix) {
        return "OPB output solver";
    }

    public int newVar(int howmany) {
        StringBuffer out = this.getOut();
        out.append(new StringBuffer().append("* #variable= ").append(howmany).toString());
        this.setNbVars(howmany);
        this.indxConstrObj = out.length();
        return 0;
    }

    public void setExpectedNumberOfClauses(int nb) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$OPBStringSolver == null ? (class$org$sat4j$pb$OPBStringSolver = OPBStringSolver.class$("org.sat4j.pb.OPBStringSolver")) : class$org$sat4j$pb$OPBStringSolver).desiredAssertionStatus();
    }
}

