/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ISolver;

public class P2DimacsReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public P2DimacsReader(MinCostDecorator solver) {
        super((ISolver)solver, "p2cnf");
    }

    protected void readProblemLine(LineNumberReader in) throws IOException, ParseFormatException {
        String line = in.readLine();
        if (line == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + in.getLineNumber());
        }
        StringTokenizer stk = new StringTokenizer(line);
        if (!(stk.hasMoreTokens() && stk.nextToken().equals("p") && stk.hasMoreTokens() && stk.nextToken().equals(this.formatString))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + in.getLineNumber());
        }
        int vars = Integer.parseInt(stk.nextToken());
        if (!$assertionsDisabled && vars <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(vars);
        this.expectedNbOfConstr = Integer.parseInt(stk.nextToken());
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
        if ("p2cnf".equals(this.formatString)) {
            String optLine = in.readLine();
            if (!optLine.startsWith("min: ")) {
                throw new ParseFormatException("p2 file does not contain the function to minimize!");
            }
            String optfunction = optLine.substring(5);
            MinCostDecorator mysolver = (MinCostDecorator)this.solver;
            Scanner values = new Scanner(optfunction);
            while (values.hasNext()) {
                int coeff = values.nextInt();
                if (!$assertionsDisabled && !values.hasNext()) {
                    throw new AssertionError();
                }
                int var = values.nextInt();
                mysolver.setCost(var, coeff);
            }
        }
    }

    static {
        $assertionsDisabled = !P2DimacsReader.class.desiredAssertionStatus();
    }
}

