/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.P2DimacsReader;
import org.sat4j.maxsat.reader.WDimacsReader;
import org.sat4j.opt.MaxSatDecorator;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class GenericOptLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("k", "kind", true, "kind of problem: minone, maxsat, etc.");
        return options;
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        System.out.println("java -jar sat4j-maxsat.jar instance-name");
    }

    protected Reader createReader(ISolver solver, String problemname) {
        if (problemname.endsWith(".wcnf")) {
            return new WDimacsReader((IPBSolver)solver);
        }
        if (problemname.endsWith("p2cnf")) {
            return new P2DimacsReader((MinCostDecorator)solver);
        }
        return new DimacsReader(solver);
    }

    protected String getInstanceName(String[] args) {
        return args[args.length - 1];
    }

    protected ISolver configureSolver(String[] args) {
        Object asolver = null;
        Options options = this.createCLIOptions();
        if (args.length == 0) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j-maxsat.jar", options, true);
        } else {
            try {
                CommandLine cmd = new PosixParser().parse(options, args);
                int problemindex = args.length - 1;
                String kind = cmd.getOptionValue("k");
                if (kind == null) {
                    kind = "maxsat";
                }
                if ("minone".equalsIgnoreCase(kind)) {
                    asolver = new MinOneDecorator((ISolver)SolverFactory.newLight());
                } else if ("mincost".equalsIgnoreCase(kind) || args[problemindex].endsWith(".p2cnf")) {
                    asolver = new MinCostDecorator(SolverFactory.newLight());
                } else {
                    if (!$assertionsDisabled && !"maxsat".equalsIgnoreCase(kind)) {
                        throw new AssertionError();
                    }
                    asolver = args[problemindex].endsWith(".wcnf") ? new WeightedMaxSatDecorator(SolverFactory.newLight()) : new MaxSatDecorator(SolverFactory.newMiniMaxSAT());
                }
                String timeout = cmd.getOptionValue("t");
                if (timeout == null) {
                    timeout = cmd.getOptionValue("T");
                    if (timeout != null) {
                        asolver.setTimeoutMs(Long.parseLong(timeout));
                    }
                } else {
                    asolver.setTimeout(Integer.parseInt(timeout));
                }
                this.log(asolver.toString("c "));
            }
            catch (ParseException e1) {
                HelpFormatter helpf = new HelpFormatter();
                helpf.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return asolver;
    }

    public static void main(String[] args) {
        GenericOptLauncher lanceur = new GenericOptLauncher();
        lanceur.run(args);
    }

    static {
        $assertionsDisabled = !GenericOptLauncher.class.desiredAssertionStatus();
    }
}

