/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ISolver;

public class WDimacsReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WDimacsReader(IPBSolver solver) {
        super((ISolver)solver, "wcnf");
    }

    public WDimacsReader(IPBSolver solver, String format) {
        super((ISolver)solver, format);
    }

    protected void readProblemLine(LineNumberReader in) throws IOException, ParseFormatException {
        String line = in.readLine();
        if (line == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + in.getLineNumber());
        }
        StringTokenizer stk = new StringTokenizer(line);
        if (!(stk.hasMoreTokens() && stk.nextToken().equals("p") && stk.hasMoreTokens() && stk.nextToken().equals(this.formatString))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + in.getLineNumber());
        }
        int vars = Integer.parseInt(stk.nextToken());
        if (!$assertionsDisabled && vars <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(vars);
        this.expectedNbOfConstr = Integer.parseInt(stk.nextToken());
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
        if ("wcnf".equals(this.formatString)) {
            int top = stk.hasMoreTokens() ? Integer.parseInt(stk.nextToken()) : Integer.MAX_VALUE;
            ((WeightedMaxSatDecorator)this.solver).setTopWeight(top);
        }
    }

    static {
        $assertionsDisabled = !WDimacsReader.class.desiredAssertionStatus();
    }
}

