/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class WeightedMaxSatDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    protected int nborigvars;
    private int nbexpectedclauses;
    private long falsifiedWeight;
    protected int nbnewvar;
    protected int[] prevfullmodel;
    protected int top = -1;
    private int counter;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    static final /* synthetic */ boolean $assertionsDisabled;

    public WeightedMaxSatDecorator(IPBSolver solver) {
        super(solver);
        IOrder order = ((Solver)solver).getOrder();
        if (order instanceof VarOrderHeapObjective) {
            ((VarOrderHeapObjective)order).setObjectiveFunction(this.obj);
        }
    }

    public int newVar(int howmany) {
        this.nborigvars = super.newVar(howmany);
        return this.nborigvars;
    }

    public void setExpectedNumberOfClauses(int nb) {
        this.nbexpectedclauses = nb;
        this.lits.ensure(nb);
        this.falsifiedWeight = 0L;
        super.setExpectedNumberOfClauses(nb);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    public int[] model() {
        int[] shortmodel = new int[this.nborigvars];
        for (int i = 0; i < this.nborigvars; ++i) {
            shortmodel[i] = this.prevfullmodel[i];
        }
        return shortmodel;
    }

    public void setTopWeight(int top) {
        this.top = top;
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        int weight = literals.get(0);
        if (weight < this.top) {
            BigInteger bigweight = BigInteger.valueOf(weight);
            if (literals.size() == 2) {
                int lit = -literals.get(1);
                int index = this.lits.containsAt(lit);
                if (index != -1) {
                    this.coefs.set(index, (Object)((BigInteger)this.coefs.get(index)).add(bigweight));
                } else {
                    index = this.lits.containsAt(-lit);
                    if (index != -1) {
                        this.falsifiedWeight += (long)weight;
                        BigInteger oldw = (BigInteger)this.coefs.get(index);
                        BigInteger diff = oldw.subtract(bigweight);
                        if (diff.signum() > 0) {
                            this.coefs.set(index, (Object)diff);
                        } else if (diff.signum() < 0) {
                            this.lits.set(index, lit);
                            this.coefs.set(index, (Object)diff.abs());
                            this.falsifiedWeight += (long)diff.intValue();
                        } else {
                            if (!$assertionsDisabled && diff.signum() != 0) {
                                throw new AssertionError();
                            }
                            this.lits.delete(index);
                            this.coefs.delete(index);
                        }
                    } else {
                        this.lits.push(lit);
                        this.coefs.push((Object)bigweight);
                    }
                }
                return null;
            }
            this.coefs.push((Object)bigweight);
            int newvar = this.nborigvars + ++this.nbnewvar;
            literals.set(0, newvar);
            this.lits.push(newvar);
        } else {
            literals.delete(0);
        }
        return super.addClause(literals);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean result = super.isSatisfiable(true);
        if (result) {
            int nbtotalvars = this.nborigvars + this.nbnewvar;
            if (this.prevfullmodel == null) {
                this.prevfullmodel = new int[nbtotalvars];
            }
            for (int i = 1; i <= nbtotalvars; ++i) {
                this.prevfullmodel[i - 1] = super.model(i) ? i : -i;
            }
        }
        return result;
    }

    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        super.reset();
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.counter = 0;
        int[] arr$ = this.prevfullmodel;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int q = arr$[i$];
            int index = this.lits.containsAt(q);
            if (index == -1) continue;
            this.counter += ((BigInteger)this.coefs.get(index)).intValue();
        }
        return new Long(this.falsifiedWeight + (long)this.counter);
    }

    public void discard() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() != this.coefs.size()) {
            throw new AssertionError();
        }
        super.addPseudoBoolean(this.lits, this.coefs, false, BigInteger.valueOf(this.counter - 1));
    }

    static {
        $assertionsDisabled = !WeightedMaxSatDecorator.class.desiredAssertionStatus();
    }
}

