/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class MinCostDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] costs;
    private int[] prevmodel;
    private final IVecInt vars = new VecInt();
    private final IVec<BigInteger> coeffs = new Vec();

    public MinCostDecorator(IPBSolver solver) {
        super(solver);
    }

    public int newVar() {
        throw new UnsupportedOperationException();
    }

    public int newVar(int howmany) {
        this.costs = new int[howmany + 1];
        this.vars.clear();
        this.coeffs.clear();
        for (int i = 1; i <= howmany; ++i) {
            this.vars.push(i);
            this.coeffs.push((Object)BigInteger.ZERO);
        }
        return super.newVar(howmany);
    }

    public int costOf(int var) {
        return this.costs[var];
    }

    public void setCost(int var, int cost) {
        this.costs[var] = cost;
        this.coeffs.set(var - 1, (Object)BigInteger.valueOf(cost));
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean result = super.isSatisfiable(true);
        if (result) {
            this.prevmodel = super.model();
        }
        return result;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        return new Integer(this.calculateDegree(this.prevmodel));
    }

    private int calculateDegree(int[] prevmodel2) {
        int tmpcost = 0;
        for (int i = 1; i < this.costs.length; ++i) {
            if (prevmodel2[i - 1] <= 0) continue;
            tmpcost += this.costs[i];
        }
        return tmpcost;
    }

    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.vars, this.coeffs, false, BigInteger.valueOf(this.calculateDegree(this.prevmodel) - 1));
    }

    public int[] model() {
        return this.prevmodel;
    }
}

