/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints;

import java.util.HashMap;
import java.util.Map;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.constraints.Relation;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Supports
implements Relation {
    private Encoding encoding;
    private final int arity;
    private int[][] tuples;
    private int lastmatch;
    private Map<Evaluable, Integer> mtuple;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$csp$constraints$Supports;

    public Supports(int arity, int nbtuples) {
        this.arity = arity;
        this.tuples = new int[nbtuples][];
    }

    @Override
    public void addTuple(int index, int[] tuple) {
        this.tuples[index] = tuple;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    @Override
    public void toClause(ISolver solver, IVec<Var> scope, IVec<Evaluable> vars) throws ContradictionException {
        if (!$assertionsDisabled && vars.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && scope.size() != this.arity) {
            throw new AssertionError();
        }
        int[] tuple = new int[scope.size()];
        this.mtuple = new HashMap<Evaluable, Integer>();
        this.lastmatch = -1;
        this.encoding = this.chooseEncoding(scope);
        this.encoding.onInit(solver, scope);
        this.find(tuple, 0, scope, solver);
        this.encoding.onFinish(solver, scope);
    }

    protected abstract Encoding chooseEncoding(IVec<Var> var1);

    private void find(int[] tuple, int n, IVec<Var> scope, ISolver solver) throws ContradictionException {
        if (n == scope.size()) {
            if (!$assertionsDisabled && this.mtuple.size() != n) {
                throw new AssertionError();
            }
            if (this.notPresent(tuple)) {
                this.encoding.onNogood(solver, scope, this.mtuple);
            } else {
                this.encoding.onSupport(solver, scope, this.mtuple);
            }
        } else {
            Domain domain = ((Var)scope.get(n)).domain();
            for (int i = 0; i < domain.size(); ++i) {
                tuple[n] = domain.get(i);
                this.mtuple.put((Evaluable)scope.get(n), new Integer(tuple[n]));
                this.find(tuple, n + 1, scope, solver);
            }
            this.mtuple.remove(scope.get(n));
        }
    }

    private boolean notPresent(int[] tuple) {
        int i = this.lastmatch + 1;
        int j = 0;
        int[][] ltuples = this.tuples;
        while (i < ltuples.length && j < tuple.length) {
            int searchedvalue = ltuples[i][j];
            int currentvalue = tuple[j];
            if (searchedvalue < currentvalue) {
                ++i;
                j = 0;
                continue;
            }
            if (searchedvalue > currentvalue) {
                return true;
            }
            ++j;
        }
        if (j == tuple.length) {
            this.lastmatch = i;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$csp$constraints$Supports == null ? (class$org$sat4j$csp$constraints$Supports = Supports.class$("org.sat4j.csp.constraints.Supports")) : class$org$sat4j$csp$constraints$Supports).desiredAssertionStatus();
    }
}

