/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.sat4j.core.Vec;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.encodings.BinarySupportEncoding;
import org.sat4j.csp.encodings.DirectEncoding;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate
implements Clausifiable {
    private String expr;
    private Encoding encoding;
    private final IVec<String> variables = new Vec();
    private static Context cx;
    private static Scriptable scope;
    private final Map<Evaluable, Integer> valuemapping = new HashMap<Evaluable, Integer>();
    private Script myscript;
    static /* synthetic */ Class class$org$sat4j$csp$Predicate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setExpression(String expr) {
        this.expr = expr.replaceAll("if\\(", "ite(");
    }

    public void addVariable(String name) {
        this.variables.push((Object)name);
    }

    private boolean evaluate(int[] values) {
        if (!$assertionsDisabled && values.length != this.variables.size()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            scope.put((String)this.variables.get(i), scope, (Object)new Integer(values[i]));
        }
        Object result = this.myscript.exec(cx, scope);
        return Context.toBoolean((Object)result);
    }

    @Override
    public void toClause(ISolver solver, IVec<Var> vscope, IVec<Evaluable> vars) throws ContradictionException {
        if (this.myscript == null) {
            this.myscript = cx.compileString(this.expr, "rhino.log", 1, null);
        }
        this.encoding = vscope.size() == 2 ? BinarySupportEncoding.instance() : DirectEncoding.instance();
        this.encoding.onInit(solver, vscope);
        int[] tuple = new int[vars.size()];
        this.valuemapping.clear();
        this.find(tuple, 0, vscope, vars, solver);
        this.encoding.onFinish(solver, vscope);
    }

    private void find(int[] tuple, int n, IVec<Var> theScope, IVec<Evaluable> vars, ISolver solver) throws ContradictionException {
        if (this.valuemapping.size() == theScope.size()) {
            for (int i = 0; i < tuple.length; ++i) {
                Evaluable ev = (Evaluable)vars.get(i);
                Integer value = this.valuemapping.get(ev);
                tuple[i] = value == null ? ev.domain().get(0) : value.intValue();
            }
            if (this.evaluate(tuple)) {
                this.encoding.onSupport(solver, theScope, this.valuemapping);
            } else {
                this.encoding.onNogood(solver, theScope, this.valuemapping);
            }
        } else {
            Var var = (Var)theScope.get(n);
            Domain domain = var.domain();
            for (int i = 0; i < domain.size(); ++i) {
                this.valuemapping.put(var, new Integer(domain.get(i)));
                this.find(tuple, n + 1, theScope, vars, solver);
            }
            this.valuemapping.remove(var);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$csp$Predicate == null ? (class$org$sat4j$csp$Predicate = Predicate.class$("org.sat4j.csp.Predicate")) : class$org$sat4j$csp$Predicate).desiredAssertionStatus();
        cx = Context.enter();
        scope = cx.initStandardObjects();
        try {
            URL url = (class$org$sat4j$csp$Predicate == null ? (class$org$sat4j$csp$Predicate = Predicate.class$("org.sat4j.csp.Predicate")) : class$org$sat4j$csp$Predicate).getResource("predefinedfunctions.js");
            cx.evaluateReader(scope, (Reader)new InputStreamReader(url.openStream()), "predefinedfunctions.js", 1, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

