/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.sat4j.core.Vec;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Constant;
import org.sat4j.csp.Domain;
import org.sat4j.csp.EnumeratedDomain;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Predicate;
import org.sat4j.csp.RangeDomain;
import org.sat4j.csp.Var;
import org.sat4j.csp.constraints.AllDiff;
import org.sat4j.csp.constraints.Nogoods;
import org.sat4j.csp.constraints.Relation;
import org.sat4j.csp.constraints.WalshSupports;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class CSPReader
extends Reader
implements ICSPCallback {
    private final ISolver solver;
    protected Relation[] relations;
    private int valueindex;
    private int relindex;
    private int[] currentdomain;
    private Domain rangedomain;
    private String currentdomainid;
    private int currentdomainsize;
    private final Map<String, Domain> domainmapping = new HashMap<String, Domain>();
    private final Map<String, Var> varmapping = new LinkedHashMap<String, Var>();
    private final Map<String, Integer> relmapping = new HashMap<String, Integer>();
    private final Map<String, Clausifiable> predmapping = new HashMap<String, Clausifiable>();
    private int nbvarstocreate;
    private int tupleindex;
    private Clausifiable currentclausifiable;
    private Predicate currentpredicate;
    private final IVec<Evaluable> variables = new Vec();
    private final IVec<Var> scope = new Vec();
    private int nbvars;
    private int nbconstraints;
    private int currentconstraint;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CSPReader(ISolver solver) {
        this.solver = solver;
        AllDiff allDiff = new AllDiff();
        this.predmapping.put("global:allDifferent", allDiff);
        this.predmapping.put("global:alldifferent", allDiff);
    }

    public final IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(in));
    }

    private IProblem parseInstance(LineNumberReader in) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.readProblem(in);
            return this.solver;
        }
        catch (NumberFormatException e) {
            throw new ParseFormatException("integer value expected on line " + in.getLineNumber(), (Throwable)e);
        }
    }

    public void decode(int[] model, PrintWriter out) {
        Iterator<Var> i$ = this.varmapping.values().iterator();
        while (i$.hasNext()) {
            Var v = i$.next();
            out.print(v.findValue(model));
            out.print(" ");
        }
    }

    public String decode(int[] model) {
        StringBuilder stb = new StringBuilder();
        Iterator<Var> i$ = this.varmapping.values().iterator();
        while (i$.hasNext()) {
            Var v = i$.next();
            stb.append(v.findValue(model));
            stb.append(" ");
        }
        return stb.toString();
    }

    private void readProblem(LineNumberReader in) throws ContradictionException {
        Scanner input = new Scanner(in);
        this.beginInstance(input.nextLine());
        int nbdomain = input.nextInt();
        this.beginDomainsSection(nbdomain);
        for (int i = 0; i < nbdomain; ++i) {
            int dnum = input.nextInt();
            if (!$assertionsDisabled && dnum != i) {
                throw new AssertionError();
            }
            int[] domain = this.readArrayOfInt(input);
            this.beginDomain("" + dnum, domain.length);
            for (int j = 0; j < domain.length; ++j) {
                this.addDomainValue(domain[j]);
            }
            this.endDomain();
        }
        this.endDomainsSection();
        int nbvar = input.nextInt();
        this.beginVariablesSection(nbvar);
        for (int i = 0; i < nbvar; ++i) {
            int varnum = input.nextInt();
            if (!$assertionsDisabled && varnum != i) {
                throw new AssertionError();
            }
            int vardom = input.nextInt();
            this.addVariable("" + varnum, "" + vardom);
        }
        this.endVariablesSection();
        int nbrel = input.nextInt();
        this.beginRelationsSection(nbrel);
        for (int i = 0; i < nbrel; ++i) {
            int relnum = input.nextInt();
            if (!$assertionsDisabled && relnum != i) {
                throw new AssertionError();
            }
            boolean forbidden = input.nextInt() != 1;
            int[] rdomains = this.readArrayOfInt(input);
            int nbtuples = input.nextInt();
            this.beginRelation("" + relnum, rdomains.length, nbtuples, !forbidden);
            for (int j = 0; j < nbtuples; ++j) {
                int[] tuple = this.readArrayOfInt(input, this.relations[relnum].arity());
                this.addRelationTuple(tuple);
            }
            this.endRelation();
        }
        this.endRelationsSection();
        int nbconstr = input.nextInt();
        this.beginConstraintsSection(nbconstr);
        for (int i = 0; i < nbconstr; ++i) {
            int[] variables = this.readArrayOfInt(input);
            this.beginConstraint("" + i, variables.length);
            int relnum = input.nextInt();
            this.constraintReference("" + relnum);
            int[] arr$ = variables;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int v = arr$[i$];
                this.addEffectiveParameter("" + v);
            }
            this.endConstraint();
        }
        this.endConstraintsSection();
        this.endInstance();
    }

    protected void manageAllowedTuples(int relnum, int arity, int nbtuples) {
        this.relations[relnum] = new WalshSupports(arity, nbtuples);
    }

    private int[] readArrayOfInt(Scanner input) {
        int size = input.nextInt();
        return this.readArrayOfInt(input, size);
    }

    private int[] readArrayOfInt(Scanner input, int size) {
        int[] tab = new int[size];
        for (int i = 0; i < size; ++i) {
            tab[i] = input.nextInt();
        }
        return tab;
    }

    public void beginInstance(String arg0) {
        System.out.println("c reading problem named " + arg0);
    }

    public void beginDomainsSection(int nbdomain) {
        System.out.print("c reading domains");
    }

    public void beginDomain(String id, int size) {
        this.currentdomainsize = size;
        this.currentdomain = null;
        this.valueindex = -1;
        this.currentdomainid = id;
        this.rangedomain = null;
    }

    public void addDomainValue(int arg0) {
        if (this.currentdomain == null) {
            this.currentdomain = new int[this.currentdomainsize];
        }
        if (this.rangedomain != null) {
            for (int i = 0; i < this.rangedomain.size(); ++i) {
                this.currentdomain[++this.valueindex] = this.rangedomain.get(i);
            }
            this.rangedomain = null;
        }
        this.currentdomain[++this.valueindex] = arg0;
    }

    public void addDomainValue(int begin, int end) {
        if (this.currentdomainsize == end - begin + 1) {
            this.rangedomain = new RangeDomain(begin, end);
        } else {
            if (this.currentdomain == null) {
                this.currentdomain = new int[this.currentdomainsize];
            }
            int v = begin;
            while (v <= end) {
                this.currentdomain[++this.valueindex] = v++;
            }
        }
    }

    public void endDomain() {
        if (!$assertionsDisabled && this.rangedomain == null && this.valueindex != this.currentdomain.length - 1) {
            throw new AssertionError();
        }
        if (this.rangedomain == null) {
            this.domainmapping.put(this.currentdomainid, new EnumeratedDomain(this.currentdomain));
        } else {
            this.domainmapping.put(this.currentdomainid, this.rangedomain);
        }
    }

    public void endDomainsSection() {
        System.out.println(" done.");
    }

    public void beginVariablesSection(int nbvars) {
        System.out.print("c reading variables");
        this.nbvarstocreate = 0;
        this.nbvars = nbvars;
    }

    public void addVariable(String idvar, String iddomain) {
        Domain vardom = this.domainmapping.get(iddomain);
        this.varmapping.put(idvar, new Var(idvar, vardom, this.nbvarstocreate));
        this.nbvarstocreate += vardom.size();
        if (this.isVerbose()) {
            System.out.print("\rc reading variables " + this.varmapping.size() + "/" + this.nbvars);
        }
    }

    public void endVariablesSection() {
        block5: {
            if (this.isVerbose()) {
                System.out.println("\rc reading variables (" + this.nbvars + ") done.");
            } else {
                System.out.println(" done.");
            }
            this.solver.newVar(this.nbvarstocreate);
            try {
                Iterator<Var> i$ = this.varmapping.values().iterator();
                while (i$.hasNext()) {
                    Var v = i$.next();
                    v.toClause(this.solver);
                }
            }
            catch (ContradictionException ce) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public void beginRelationsSection(int nbrel) {
        System.out.print("c reading relations");
        this.relations = new Relation[nbrel];
        this.relindex = -1;
    }

    public void beginRelation(String name, int arity, int nbTuples, boolean isSupport) {
        this.relmapping.put(name, new Integer(++this.relindex));
        if (this.isVerbose()) {
            System.out.print("\rc reading relations " + this.relindex + "/" + this.relations.length);
        }
        if (isSupport) {
            this.manageAllowedTuples(this.relindex, arity, nbTuples);
        } else {
            this.relations[this.relindex] = new Nogoods(arity, nbTuples);
        }
        this.tupleindex = -1;
    }

    public void addRelationTuple(int[] tuple) {
        this.relations[this.relindex].addTuple(++this.tupleindex, tuple);
    }

    public void endRelation() {
    }

    public void endRelationsSection() {
        if (this.isVerbose()) {
            System.out.println("\rc reading relations (" + this.relations.length + ") done.");
        } else {
            System.out.println(" done.");
        }
    }

    public void beginPredicatesSection(int arg0) {
        System.out.print("c reading predicates ");
    }

    public void beginPredicate(String name) {
        this.currentpredicate = new Predicate();
        this.predmapping.put(name, this.currentpredicate);
        if (this.isVerbose()) {
            System.out.print("\rc reading predicate " + this.predmapping.size());
        }
    }

    public void addFormalParameter(String name, String type) {
        this.currentpredicate.addVariable(name);
    }

    public void predicateExpression(String expr) {
        this.currentpredicate.setExpression(expr);
    }

    public void endPredicate() {
    }

    public void endPredicatesSection() {
        if (this.isVerbose()) {
            System.out.println("\rc reading relations (" + this.predmapping.size() + ") done.");
        } else {
            System.out.println(" done.");
        }
    }

    public void beginConstraintsSection(int arg0) {
        System.out.println("c reading constraints");
        this.nbconstraints = arg0;
        this.currentconstraint = 0;
    }

    public void beginConstraint(String name, int arity) {
        this.variables.clear();
        this.variables.ensure(arity);
        this.scope.clear();
        this.scope.ensure(arity);
        if (this.isVerbose()) {
            System.out.print("\rc grounding constraint " + name + "(" + ++this.currentconstraint * 100 / this.nbconstraints + "%)");
        }
    }

    public void constraintReference(String ref) {
        Integer id = this.relmapping.get(ref);
        this.currentclausifiable = id == null ? this.predmapping.get(ref) : this.relations[id];
        if (this.currentclausifiable == null) {
            throw new IllegalArgumentException("Reference not supported:  " + ref);
        }
    }

    public void addVariableToConstraint(String arg0) {
        this.scope.push((Object)this.varmapping.get(arg0));
    }

    public void addEffectiveParameter(String arg0) {
        this.variables.push((Object)this.varmapping.get(arg0));
    }

    public void addEffectiveParameter(int arg0) {
        this.variables.push((Object)new Constant(arg0));
    }

    public void beginParameterList() {
        throw new UnsupportedOperationException("I do not handle parameter list yet!");
    }

    public void addIntegerItem(int arg0) {
    }

    public void addVariableItem(String arg0) {
    }

    public void endParamaterList() {
    }

    public void addConstantParameter(String arg0, int arg1) {
        throw new UnsupportedOperationException("I do not handle constant parameter yet!");
    }

    public void constraintExpression(String arg0) {
        throw new UnsupportedOperationException("I do not handle constraint expression yet!");
    }

    public void endConstraint() {
        try {
            this.currentclausifiable.toClause(this.solver, this.scope, this.variables);
        }
        catch (ContradictionException e) {
            System.err.println("c INSTANCE TRIVIALLY UNSAT");
        }
    }

    public void endConstraintsSection() {
        if (this.isVerbose()) {
            System.out.println("\rc reading constraints done.");
        } else {
            System.out.println("c done with constraints.");
        }
    }

    public void endInstance() {
    }

    IProblem getProblem() {
        return this.solver;
    }

    static {
        $assertionsDisabled = !CSPReader.class.desiredAssertionStatus();
    }
}

