/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.CSPReader;
import org.sat4j.reader.CSPSupportReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class CSPInstanceReader
extends InstanceReader {
    private CSPReader csp;
    private CSPReader csp2;
    private CSPReader csp3;
    private XMLCSPReader xmlcsp;
    private Reader reader = null;
    private final ISolver solver;

    public CSPInstanceReader(ISolver solver) {
        super(solver);
        this.solver = solver;
    }

    private Reader getCSPReader1() {
        if (this.csp == null) {
            this.csp = new CSPReader(this.solver);
        }
        return this.csp;
    }

    private Reader getCSPReader2() {
        if (this.csp2 == null) {
            this.csp2 = new CSPSupportReader(this.solver);
        }
        return this.csp2;
    }

    private Reader getCSPReader3() {
        if (this.csp3 == null) {
            this.csp3 = new CSPExtSupportReader(this.solver);
        }
        return this.csp3;
    }

    private Reader getXMLCSPReader() {
        if (this.xmlcsp == null) {
            this.xmlcsp = new XMLCSPReader(this.solver);
        }
        return this.xmlcsp;
    }

    public IProblem parseInstance(String filename) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        boolean isHttp = false;
        String tempFileName = "";
        String prefix = "";
        if (filename.startsWith("http://")) {
            isHttp = true;
            tempFileName = filename;
            filename = filename.substring(filename.lastIndexOf(47), filename.length() - 1);
        }
        if (filename.indexOf(58) != -1) {
            String[] parts = filename.split(":");
            filename = parts[1];
            prefix = parts[0].toUpperCase(Locale.getDefault());
        }
        String fname = filename.endsWith(".gz") ? filename.substring(0, filename.lastIndexOf(46)) : filename;
        if ("CSP".equals(prefix)) {
            this.reader = this.getCSPReader1();
        } else if ("CSP3".equals(prefix)) {
            this.reader = this.getCSPReader3();
        } else if (fname.endsWith(".txt") || "CSP2".equals(prefix)) {
            this.reader = this.getCSPReader2();
        }
        if (!fname.endsWith(".xml")) {
            return super.parseInstance(filename);
        }
        this.reader = this.getXMLCSPReader();
        if (isHttp) {
            return this.reader.parseInstance(new URL(tempFileName).openStream());
        }
        return this.reader.parseInstance(filename);
    }

    @Deprecated
    public String decode(int[] model) {
        return this.reader.decode(model);
    }

    public void decode(int[] model, PrintWriter out) {
        this.reader.decode(model, out);
    }

    public IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }
}

