/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.core.VecInt;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Evaluable;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class Var
implements Evaluable {
    private final Domain domain;
    private final String id;
    private final int startid;

    public Var(String idvar, Domain domain, int lastvarnumber) {
        this.domain = domain;
        this.id = idvar;
        this.startid = lastvarnumber + 1;
    }

    public Domain domain() {
        return this.domain;
    }

    public int translate(int key) {
        return this.domain.pos(key) + this.startid;
    }

    public void toClause(ISolver solver) throws ContradictionException {
        VecInt clause = new VecInt(this.domain.size());
        for (int i = 0; i < this.domain.size(); ++i) {
            clause.push(i + this.startid);
        }
        solver.addClause((IVecInt)clause);
        solver.addAtMost((IVecInt)clause, 1);
    }

    public int findValue(int[] model) {
        for (int i = 0; i < this.domain.size(); ++i) {
            int varnum = i + this.startid;
            if (model[varnum - 1] != varnum) continue;
            return this.domain.get(i);
        }
        throw new RuntimeException("BIG PROBLEM: no value for a var!");
    }

    public String toString() {
        return this.id;
    }
}

