/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.AbstractLauncher;
import org.sat4j.csp.SolverFactory;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ISolver configureSolver(String[] args) {
        ISolver asolver = SolverFactory.newDefault();
        this.log(asolver.toString("c "));
        return asolver;
    }

    protected Reader createReader(ISolver solver, String problemname) {
        Reader reader;
        if (problemname.endsWith(".txt")) {
            reader = new CSPExtSupportReader(solver);
        } else {
            if (!$assertionsDisabled && !problemname.endsWith(".xml")) {
                throw new AssertionError();
            }
            reader = new XMLCSPReader(solver);
        }
        if (System.getProperty("verbose") != null) {
            this.log("verbose mode on");
            reader.setVerbosity(true);
        }
        return reader;
    }

    public static void main(String[] args) {
        CSPLauncher lanceur = new CSPLauncher();
        if (args.length != 1) {
            lanceur.usage();
            return;
        }
        try {
            lanceur.run(args);
        }
        catch (IllegalArgumentException e) {
            lanceur.log(">>>> " + e.getMessage() + " <<<<");
        }
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("That software uses the Rhino library from the Mozilla project.");
    }

    public void usage() {
        System.out.println("Please provide a CSP instance file!");
    }

    protected String getInstanceName(String[] args) {
        if (!$assertionsDisabled && args.length != 1) {
            throw new AssertionError();
        }
        return args[0];
    }

    static {
        $assertionsDisabled = !CSPLauncher.class.desiredAssertionStatus();
    }
}

