/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import junit.framework.TestCase;
import org.sat4j.csp.RangeDomain;
import org.sat4j.specs.IteratorInt;

public class RangeDomainTest
extends TestCase {
    public void testSize() {
        RangeDomain domain = new RangeDomain(3, 4);
        RangeDomainTest.assertEquals((int)2, (int)domain.size());
    }

    public void testGet() {
        RangeDomain domain = new RangeDomain(2, 5);
        RangeDomainTest.assertEquals((int)4, (int)domain.size());
        RangeDomainTest.assertEquals((int)2, (int)domain.get(0));
        RangeDomainTest.assertEquals((int)3, (int)domain.get(1));
        RangeDomainTest.assertEquals((int)4, (int)domain.get(2));
        RangeDomainTest.assertEquals((int)5, (int)domain.get(3));
    }

    public void testIterator() {
        RangeDomain domain = new RangeDomain(2, 5);
        IteratorInt it = domain.iterator();
        RangeDomainTest.assertTrue((boolean)it.hasNext());
        RangeDomainTest.assertEquals((int)2, (int)it.next());
        RangeDomainTest.assertTrue((boolean)it.hasNext());
        RangeDomainTest.assertEquals((int)3, (int)it.next());
        RangeDomainTest.assertTrue((boolean)it.hasNext());
        RangeDomainTest.assertEquals((int)4, (int)it.next());
        RangeDomainTest.assertTrue((boolean)it.hasNext());
        RangeDomainTest.assertEquals((int)5, (int)it.next());
        RangeDomainTest.assertFalse((boolean)it.hasNext());
    }

    public void testNegativeBounds() {
        RangeDomain domain = new RangeDomain(-2, 4);
        RangeDomainTest.assertEquals((int)7, (int)domain.size());
    }

    public void testPos() {
        RangeDomain domain = new RangeDomain(1, 5);
        RangeDomainTest.assertEquals((int)1, (int)domain.pos(2));
        RangeDomainTest.assertEquals((int)0, (int)domain.pos(1));
        RangeDomainTest.assertEquals((int)2, (int)domain.pos(3));
        RangeDomainTest.assertEquals((int)3, (int)domain.pos(4));
        RangeDomainTest.assertEquals((int)4, (int)domain.pos(5));
    }
}

