/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.calendar.api.CalendarEvent;
import org.sakaiproject.calendar.api.CalendarEventEdit;
import org.sakaiproject.calendaring.api.ExternalCalendaringService;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.util.PlainTextFormat;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeRange;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignupCalendarHelperImpl
implements SignupCalendarHelper {
    private static final Logger log = LoggerFactory.getLogger(SignupCalendarHelperImpl.class);
    protected static ResourceLoader rb = new ResourceLoader("emailMessage");
    public static final String newline = "<br />";
    private SakaiFacade sakaiFacade;
    private ExternalCalendaringService externalCalendaringService;

    public CalendarEventEdit generateEvent(SignupMeeting m) {
        return this.generateEvent(m, null);
    }

    public CalendarEventEdit generateEvent(SignupMeeting m, SignupTimeslot ts) {
        Date end;
        Date start;
        String siteId = ((SignupSite)m.getSignupSites().get(0)).getSiteId();
        if (ts == null) {
            start = m.getStartTime();
            end = m.getEndTime();
        } else {
            start = ts.getStartTime();
            end = ts.getEndTime();
        }
        String title = m.getTitle();
        String description = m.getDescription();
        String location = m.getLocation();
        return this.generateEvent(siteId, start, end, title, description, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VEvent generateVEventForTimeslot(SignupMeeting meeting, SignupTimeslot ts) {
        if (meeting == null) {
            log.error("Meeting was null. Cannot generate VEvent.");
            return null;
        }
        if (ts == null) {
            log.error("Timeslot was null. Cannot generate VEvent.");
            return null;
        }
        VEvent v = ts.getVevent();
        if (v == null) {
            SecurityAdvisor advisor = this.sakaiFacade.pushSecurityAdvisor();
            try {
                CalendarEventEdit tsEvent = this.generateEvent(meeting, ts);
                if (tsEvent == null) {
                    VEvent vEvent = null;
                    return vEvent;
                }
                tsEvent.setField("vevent_uuid", ts.getUuid());
                tsEvent.setField("vevent_sequence", String.valueOf(ts.getVersion()));
                tsEvent.getProperties().addProperty("CHEF:creator", meeting.getCreatorUserId());
                v = this.externalCalendaringService.createEvent((CalendarEvent)tsEvent);
                this.externalCalendaringService.addChairAttendeesToEvent(v, this.getCoordinators(meeting));
            }
            finally {
                this.sakaiFacade.popSecurityAdvisor(advisor);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VEvent generateVEventForMeeting(SignupMeeting meeting) {
        if (meeting == null) {
            log.error("Meeting was null. Cannot generate VEvent.");
            return null;
        }
        VEvent v = meeting.getVevent();
        if (v == null) {
            SecurityAdvisor advisor = this.sakaiFacade.pushSecurityAdvisor();
            try {
                CalendarEventEdit mEvent = this.generateEvent(meeting);
                if (mEvent == null) {
                    VEvent vEvent = null;
                    return vEvent;
                }
                mEvent.setField("vevent_uuid", meeting.getUuid());
                mEvent.setField("vevent_sequence", String.valueOf(meeting.getVersion()));
                mEvent.getProperties().addProperty("CHEF:creator", meeting.getCreatorUserId());
                v = this.externalCalendaringService.createEvent((CalendarEvent)mEvent);
                this.externalCalendaringService.addChairAttendeesToEvent(v, this.getCoordinators(meeting));
            }
            finally {
                this.sakaiFacade.popSecurityAdvisor(advisor);
            }
        }
        return v;
    }

    private Set<User> getCoordinators(SignupMeeting meeting) {
        HashSet<User> users = new HashSet<User>();
        List ids = meeting.getCoordinatorIdsList();
        for (String coordinator : ids) {
            users.add(this.sakaiFacade.getUserQuietly(coordinator));
        }
        return users;
    }

    public String createCalendarFile(List<VEvent> vevents) {
        Calendar cal = this.externalCalendaringService.createCalendar(vevents);
        return this.externalCalendaringService.toFile(cal);
    }

    public String createCalendarFile(List<VEvent> vevents, String method) {
        Calendar cal = this.externalCalendaringService.createCalendar(vevents, method);
        return this.externalCalendaringService.toFile(cal);
    }

    public VEvent cancelVEvent(VEvent vevent) {
        return this.externalCalendaringService.cancelEvent(vevent);
    }

    public VEvent addUsersToVEvent(VEvent vevent, Set<User> users) {
        return this.externalCalendaringService.addAttendeesToEvent(vevent, users);
    }

    public VEvent addAttendeesToVEvent(VEvent vevent, Set<SignupAttendee> attendees) {
        HashSet<User> users = new HashSet<User>();
        for (SignupAttendee attendee : attendees) {
            User user = this.sakaiFacade.getUser(attendee.getAttendeeUserId());
            if (user == null) continue;
            users.add(user);
        }
        return this.externalCalendaringService.addAttendeesToEvent(vevent, users);
    }

    public boolean isIcsEnabled() {
        return this.externalCalendaringService.isIcsEnabled();
    }

    private CalendarEventEdit generateEvent(String siteId, Date startTime, Date endTime, String title, String description, String location) {
        CalendarEventEdit event = null;
        try {
            org.sakaiproject.calendar.api.Calendar calendar = this.sakaiFacade.getCalendar(siteId);
            if (calendar == null) {
                return null;
            }
            event = calendar.addEvent();
            event.setType("Meeting");
            TimeService timeService = this.sakaiFacade.getTimeService();
            Time start = timeService.newTime(startTime.getTime());
            Time end = timeService.newTime(endTime.getTime());
            TimeRange timeRange = timeService.newTimeRange(start, end, true, false);
            event.setRange(timeRange);
            event.setDisplayName(title);
            event.setDescription(PlainTextFormat.convertFormattedHtmlTextToICalText(this.addWarningMessageForCancellation(description, siteId)));
            event.setLocation(location);
            String url = this.getSiteAccessUrl(siteId);
            if (StringUtils.isNotBlank((String)url)) {
                event.setField("vevent_url", url);
            }
        }
        catch (PermissionException e) {
            log.error("SignupCalendarHelperImpl.generateEvent: " + (Object)((Object)e));
            return null;
        }
        return event;
    }

    private String addWarningMessageForCancellation(String meetingDesc, String siteId) {
        meetingDesc = meetingDesc == null ? " " : meetingDesc;
        StringBuffer sb = new StringBuffer(meetingDesc);
        sb.append("<br /><br />");
        sb.append(rb.getString("ical.footer.separator"));
        sb.append(newline + rb.getString("ical.footer.text"));
        return sb.toString();
    }

    private String getSiteAccessUrl(String siteId) {
        if (StringUtils.isNotBlank((String)siteId)) {
            return this.sakaiFacade.getServerConfigurationService().getPortalUrl() + "/site/" + siteId + "/page/" + this.sakaiFacade.getCurrentPageId();
        }
        return null;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public void setExternalCalendaringService(ExternalCalendaringService externalCalendaringService) {
        this.externalCalendaringService = externalCalendaringService;
    }
}

