/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.util.List;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailDeliverer
implements Runnable {
    private List<User> sakaiUsers;
    private final EmailService emailService;
    private Logger logger = LoggerFactory.getLogger(EmailDeliverer.class);
    private final List<String> headers;
    private final String message;

    public EmailDeliverer(List<User> sakaiUsers, List<String> headers, String message, EmailService emailService) {
        this.sakaiUsers = sakaiUsers;
        this.headers = headers;
        this.message = message;
        this.emailService = emailService;
    }

    @Override
    public void run() {
        try {
            this.emailService.sendToUsers(this.sakaiUsers, this.headers, this.message);
        }
        catch (Exception e) {
            this.logger.warn("The emails may not be sent away due to error: " + e.getMessage());
        }
        finally {
            if (this.sakaiUsers != null) {
                this.sakaiUsers.clear();
            }
            this.sakaiUsers = null;
        }
    }
}

