/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fortuna.ical4j.model.component.VEvent;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.logic.messages.SignupTimeslotChanges;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class AttendeeCancellationOwnEmail
extends SignupEmailBase
implements SignupTimeslotChanges {
    private final User attendee;
    private final SignupTimeslot timeslot;
    private List<SignupTimeslot> removed;

    public AttendeeCancellationOwnEmail(User attendee, List<SignupTrackingItem> items, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.attendee = attendee;
        this.meeting = meeting;
        SignupTimeslot timeslot = null;
        for (SignupTrackingItem item : items) {
            if (!item.isInitiator()) continue;
            this.removed = item.getRemovedFromTimeslot();
            timeslot = this.removed.get(0);
        }
        this.timeslot = timeslot;
        this.setSakaiFacade(sakaiFacade);
        this.cancellation = true;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.attendee.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.attendee.getDisplayName())));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.cancel.own"), this.getSiteTitleWithQuote(), this.getServiceName()));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        message.append("<BR>\r\n" + rb.getString("body.timeslot") + " ");
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.timeslot.getStartTime()).toStringLocalTime(), this.getTime(this.timeslot.getEndTime()).toStringLocalTime(), this.getTime(this.timeslot.getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append(MessageFormat.format(rb.getString("body.meeting.timeslot.timeframe"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.timeslot.getStartTime()).toStringLocalTime(), this.getTime(this.timeslot.getStartTime()).toStringLocalShortDate(), this.getTime(this.timeslot.getEndTime()).toStringLocalTime(), this.getTime(this.timeslot.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append(MessageFormat.format(rb.getString("body.meeting.crossdays.timeslot.timeframe"), paramsTimeframe));
        }
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n"));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return this.getServerFromAddress();
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.attendee.cancel.own.field"), this.getAbbreviatedMeetingTitle(), this.getSiteTitle());
    }

    public List<SignupTimeslot> getRemoved() {
        return this.removed;
    }

    public List<SignupTimeslot> getAdded() {
        return Collections.EMPTY_LIST;
    }

    public List<VEvent> generateEvents(User user, SignupCalendarHelper calendarHelper) {
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        for (SignupTimeslot timeslot : this.removed) {
            VEvent event = timeslot.getVevent();
            calendarHelper.cancelVEvent(event);
            events.add(event);
        }
        return events;
    }
}

