/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.CacheRefresher;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.signup.dao.SignupMeetingDao;
import org.sakaiproject.signup.logic.SignupCacheService;
import org.sakaiproject.signup.model.SignupMeeting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignupCacheServiceImpl
implements SignupCacheService,
CacheRefresher {
    private MemoryService memoryService;
    protected SignupMeetingDao signupMeetingDao;
    private static Logger M_log = LoggerFactory.getLogger(SignupCacheServiceImpl.class);
    private Cache m_signupSiteCache = null;
    public static SignupCacheServiceImpl m_instance = null;

    public void init() {
        try {
            this.m_signupSiteCache = this.memoryService.newCache("org.sakaiproject.signup.logic.siteCache");
            if (m_instance == null) {
                m_instance = this;
            }
            if (M_log.isDebugEnabled()) {
                M_log.debug(this + ".init()");
            }
        }
        catch (Throwable t) {
            M_log.warn(this + "init(): ", t);
        }
    }

    public List<SignupMeeting> getAllSignupMeetingsInSite(String siteId, Date startDate, int timeLengthInDays) {
        List<SignupMeeting> sEvents = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(10, 24 * timeLengthInDays);
        Date endDate = calendar.getTime();
        String searchKey = siteId + "_" + timeLengthInDays;
        Object cached = this.getCachedValue(searchKey);
        if (cached != null) {
            sEvents = (List<SignupMeeting>)cached;
            return sEvents;
        }
        sEvents = this.getSignupMeetingDao().getSignupMeetingsInSite(siteId, startDate, endDate);
        if (sEvents == null || sEvents.isEmpty()) {
            return null;
        }
        if (this.m_signupSiteCache != null) {
            this.m_signupSiteCache.put((Object)searchKey, sEvents);
        }
        return sEvents;
    }

    public List<SignupMeeting> getAllSignupMeetingsInSites(List<String> siteIds, Date startDate, int searchTimeFrame) {
        ArrayList<SignupMeeting> allSearchSitesEvents = new ArrayList<SignupMeeting>();
        if (siteIds != null) {
            for (String siteId : siteIds) {
                List<SignupMeeting> oneSiteEvents = this.getAllSignupMeetingsInSite(siteId, startDate, searchTimeFrame);
                if (oneSiteEvents == null || oneSiteEvents.isEmpty()) continue;
                allSearchSitesEvents.addAll(oneSiteEvents);
            }
        }
        return allSearchSitesEvents;
    }

    private Object getCachedValue(String searchKey) {
        return this.m_signupSiteCache != null ? this.m_signupSiteCache.get((Object)searchKey) : null;
    }

    public void destroy() {
        if (this.m_signupSiteCache != null) {
            this.m_signupSiteCache.close();
        }
        M_log.info("destroy()");
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        return null;
    }

    public MemoryService getMemoryService() {
        return this.memoryService;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.memoryService = memoryService;
    }

    public SignupMeetingDao getSignupMeetingDao() {
        return this.signupMeetingDao;
    }

    public void setSignupMeetingDao(SignupMeetingDao signupMeetingDao) {
        this.signupMeetingDao = signupMeetingDao;
    }
}

