/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.calendar.api.Calendar;
import org.sakaiproject.calendar.api.CalendarEdit;
import org.sakaiproject.calendar.api.CalendarService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SakaiFacadeImpl
implements SakaiFacade {
    private static Logger log = LoggerFactory.getLogger(SakaiFacadeImpl.class);
    private FunctionManager functionManager;
    private static ResourceLoader rb = new ResourceLoader();
    private ToolManager toolManager;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private SiteService siteService;
    private UserDirectoryService userDirectoryService;
    private CalendarService calendarService;
    private ServerConfigurationService serverConfigurationService;
    private AuthzGroupService authzGroupService;
    private TimeService timeService;
    private ContentHostingService contentHostingService;

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setCalendarService(CalendarService calendarService) {
        this.calendarService = calendarService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public AuthzGroupService getAuthzGroupService() {
        return this.authzGroupService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public Calendar getAdditionalCalendar(String siteId) throws PermissionException {
        CalendarService additionalCalendarService = null;
        additionalCalendarService = (CalendarService)ComponentManager.get((String)"org.sakaiproject.additional.calendar");
        if (additionalCalendarService != null && additionalCalendarService.isCalendarToolInitialized(siteId)) {
            try {
                return additionalCalendarService.getCalendar(siteId);
            }
            catch (IdUnusedException e) {
                log.error("Error retrieving Calendar." + e.getMessage());
            }
        }
        return null;
    }

    public void init() {
        log.debug("init");
        this.functionManager.registerFunction("signup.view");
        this.functionManager.registerFunction("signup.view.all");
        this.functionManager.registerFunction("signup.attend");
        this.functionManager.registerFunction("signup.attend.all");
        this.functionManager.registerFunction("signup.create.site");
        this.functionManager.registerFunction("signup.create.group");
        this.functionManager.registerFunction("signup.create.group.all");
        this.functionManager.registerFunction("signup.delete.site");
        this.functionManager.registerFunction("signup.delete.group");
        this.functionManager.registerFunction("signup.delete.group.all");
        this.functionManager.registerFunction("signup.update.site");
        this.functionManager.registerFunction("signup.update.group");
        this.functionManager.registerFunction("signup.update.group.all");
    }

    public boolean isUserAdmin(String userId) {
        return this.securityService.isSuperUser(userId);
    }

    public String getCurrentUserId() {
        return this.sessionManager.getCurrentSessionUserId();
    }

    public User getUser(String userId) {
        try {
            return this.userDirectoryService.getUser(userId);
        }
        catch (UserNotDefinedException e) {
            log.warn("Cannot get user for id: " + userId);
            return null;
        }
    }

    public User getUserQuietly(String userId) {
        try {
            return this.userDirectoryService.getUser(userId);
        }
        catch (UserNotDefinedException e) {
            log.debug("User with id: " + userId + " does not exist : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage());
            return null;
        }
    }

    public boolean checkForUser(String userId) {
        try {
            User u = this.userDirectoryService.getUser(userId);
            if (u != null) {
                return true;
            }
        }
        catch (UserNotDefinedException e) {
            log.debug("User with id: " + userId + " does not exist : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage());
        }
        return false;
    }

    public String getUserDisplayName(String userId) {
        try {
            return this.userDirectoryService.getUser(userId).getDisplayName();
        }
        catch (UserNotDefinedException e) {
            log.warn("Cannot get user displayname for id: " + userId);
            return "--------";
        }
    }

    public String getUserDisplayLastFirstName(String userId) {
        try {
            String dispFirstName;
            String dispLastName = this.userDirectoryService.getUser(userId).getLastName();
            if (dispLastName != null) {
                dispLastName = StringUtils.lowerCase((String)dispLastName, (Locale)rb.getLocale());
                dispLastName = StringUtils.capitalize((String)dispLastName);
            }
            if ((dispFirstName = this.userDirectoryService.getUser(userId).getFirstName()) != null) {
                dispFirstName = StringUtils.lowerCase((String)dispFirstName, (Locale)rb.getLocale());
                dispFirstName = StringUtils.capitalize((String)dispFirstName);
            }
            String displayname = null;
            displayname = !(dispLastName != null && !dispLastName.isEmpty() || dispFirstName != null && !dispFirstName.isEmpty()) ? this.userDirectoryService.getUser(userId).getDisplayId() : dispLastName + ", " + dispFirstName;
            return displayname;
        }
        catch (UserNotDefinedException e) {
            log.warn("Cannot get user displayname for id: " + userId);
            return "--------";
        }
    }

    public String getCurrentLocationId() {
        try {
            return this.toolManager.getCurrentPlacement().getContext();
        }
        catch (Exception e) {
            log.info("Failed to get current location id");
            return "noLocationAvailable";
        }
    }

    public String getCurrentPageId() {
        return this.getSiteSignupPageId(this.getCurrentLocationId());
    }

    public String getSiteSignupPageId(String siteId) {
        try {
            Site appliedSite = this.siteService.getSite(siteId);
            String signupToolId = null;
            try {
                signupToolId = this.toolManager.getCurrentPlacement().getToolId();
            }
            catch (Exception e) {
                signupToolId = this.toolManager.getTool("sakai.signup").getId();
            }
            SitePage page = null;
            List pageList = appliedSite.getPages();
            for (int i = 0; i < pageList.size(); ++i) {
                String toolId;
                ToolConfiguration toolConf;
                page = (SitePage)pageList.get(i);
                List pageToolList = page.getTools();
                if (pageToolList == null || pageToolList.isEmpty() || (toolConf = (ToolConfiguration)pageToolList.get(0)) == null || !(toolId = toolConf.getToolId()).equalsIgnoreCase(signupToolId)) continue;
                return page.getId();
            }
        }
        catch (Exception e) {
            log.warn("Failed to get current page id");
        }
        return "";
    }

    public String getLocationTitle(String locationId) {
        try {
            Site site = this.siteService.getSite(locationId);
            return site.getTitle();
        }
        catch (IdUnusedException e) {
            log.warn("Cannot get the info about locationId: " + locationId);
            return "----------";
        }
    }

    public List<String> getUserPublishedSiteIds(String userId) {
        ArrayList<String> siteIds = new ArrayList<String>();
        List tempL = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.TITLE_ASC, null);
        for (Site element : tempL) {
            Collection tools;
            if (this.siteService.isUserSite(element.getId()) || this.siteService.isSpecialSite(element.getId()) || (tools = element.getTools("sakai.signup")) == null || tools.isEmpty() || !element.isPublished()) continue;
            siteIds.add(element.getId());
        }
        return siteIds;
    }

    public List<SignupSite> getUserSites(String userId) {
        ArrayList<SignupSite> signupSites = new ArrayList<SignupSite>();
        List tempL = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.TITLE_ASC, null);
        if (this.isUserAdmin(this.getCurrentUserId())) {
            String currentSitId = this.getCurrentLocationId();
            Site curSite = null;
            try {
                curSite = this.getSiteService().getSite(currentSitId);
            }
            catch (IdUnusedException e) {
                log.warn("IdUnusedException:" + e.getMessage());
            }
            if (currentSitId != null && curSite != null) {
                boolean foundSite = false;
                for (Site s : tempL) {
                    if (!currentSitId.equals(s.getId())) continue;
                    foundSite = true;
                    break;
                }
                if (!foundSite) {
                    tempL.add(curSite);
                }
            }
        }
        for (Site element : tempL) {
            Collection tools;
            if (this.siteService.isUserSite(element.getId()) || this.siteService.isSpecialSite(element.getId()) || (tools = element.getTools("sakai.signup")) == null || tools.isEmpty()) continue;
            SignupSite tmpSite = new SignupSite();
            tmpSite.setSiteId(element.getId());
            tmpSite.setTitle(element.getTitle());
            signupSites.add(tmpSite);
            ArrayList<SignupGroup> groupList = new ArrayList<SignupGroup>();
            Collection tmpGroup = element.getGroups();
            for (Group grp : tmpGroup) {
                String gProp = grp.getProperties().getProperty("group_prop_signup_ignore");
                if (gProp != null && gProp.equals(Boolean.TRUE.toString())) continue;
                SignupGroup sgrp = new SignupGroup();
                sgrp.setGroupId(grp.getId());
                sgrp.setTitle(grp.getTitle());
                groupList.add(sgrp);
            }
            tmpSite.setSignupGroups(groupList);
        }
        return signupSites;
    }

    public boolean isAllowedGroup(String userId, String permission, String siteId, String groupId) {
        return this.isAllowed(userId, permission, this.siteService.siteGroupReference(siteId, groupId));
    }

    public boolean isAllowedSite(String userId, String permission, String siteId) {
        return this.isAllowed(userId, permission, this.siteService.siteReference(siteId));
    }

    private boolean isAllowed(String userId, String permission, String realmId) {
        return this.securityService.unlock(userId, permission, realmId);
    }

    public String getUserId(String eid) throws UserNotDefinedException {
        return this.userDirectoryService.getUserId(eid);
    }

    public List<SignupUser> getAllUsers(SignupMeeting meeting) {
        List signupSites = meeting.getSignupSites();
        TreeSet<SignupUser> signupUsers = new TreeSet<SignupUser>();
        for (SignupSite signupSite : signupSites) {
            if (signupSite.isSiteScope()) {
                this.getUsersForSiteWithSiteScope(signupUsers, signupSite);
                continue;
            }
            List signupGroups = signupSite.getSignupGroups();
            for (SignupGroup signupGroup : signupGroups) {
                this.getUsersForGroup(signupUsers, signupSite, signupGroup);
            }
        }
        return new ArrayList<SignupUser>(signupUsers);
    }

    public List<SignupUser> getAllPossibleAttendees(SignupMeeting meeting) {
        List signupSites = meeting.getSignupSites();
        TreeSet<SignupUser> signupUsers = new TreeSet<SignupUser>();
        for (SignupSite signupSite : signupSites) {
            if (signupSite.isSiteScope()) {
                this.getAttendeesForSiteWithSiteScope(signupUsers, signupSite);
                continue;
            }
            List signupGroups = signupSite.getSignupGroups();
            for (SignupGroup signupGroup : signupGroups) {
                this.getAttendeesForGroup(signupUsers, signupSite, signupGroup);
            }
        }
        return new ArrayList<SignupUser>(signupUsers);
    }

    public List<SignupUser> getAllPossibleCoordinators(SignupMeeting meeting) {
        ArrayList<SignupUser> coordinators = new ArrayList<SignupUser>();
        List<SignupUser> signUpUsers = this.getAllUsers(meeting);
        List signupSites = meeting.getSignupSites();
        HashSet<String> userIdsHasPermissionToCreate = new HashSet<String>();
        if (signupSites != null) {
            for (SignupSite site : signupSites) {
                userIdsHasPermissionToCreate.addAll(this.getUserIdsHasPermissionToCreate(site));
            }
        }
        for (SignupUser signUpUser : signUpUsers) {
            if (!userIdsHasPermissionToCreate.contains(signUpUser.getInternalUserId())) continue;
            coordinators.add(signUpUser);
        }
        return coordinators;
    }

    public List<SignupUser> getAllPossbileCoordinatorsOnFastTrack(SignupMeeting meeting) {
        ArrayList<SignupUser> coordinators = new ArrayList<SignupUser>();
        List signupSites = meeting.getSignupSites();
        HashSet<String> userIdsHasPermissionToCreate = new HashSet<String>();
        if (signupSites != null) {
            for (SignupSite site : signupSites) {
                userIdsHasPermissionToCreate.addAll(this.getUserIdsHasPermissionToCreate(site));
            }
        }
        List sakaiUsers = this.userDirectoryService.getUsers(userIdsHasPermissionToCreate);
        for (User user : sakaiUsers) {
            SignupUser signupUser = new SignupUser(user.getEid(), user.getId(), user.getFirstName(), user.getLastName(), null, "", true);
            coordinators.add(signupUser);
        }
        return coordinators;
    }

    private Set<String> getUserIdsHasPermissionToCreate(SignupSite site) {
        HashSet<String> userIds = new HashSet<String>();
        userIds.addAll(this.getUserIdsWithPermission("signup.create.site", site.getSiteId()));
        if (!site.isSiteScope()) {
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                userIds.addAll(this.getUserIdsWithPermission("signup.create.group.all", site.getSiteId(), group.getGroupId()));
                userIds.addAll(this.getUserIdsWithPermission("signup.create.group", site.getSiteId(), group.getGroupId()));
            }
        }
        return userIds;
    }

    private List<String> getUserIdsWithPermission(String permission, String siteId) {
        return this.getUserIdsWithPermissionOnRealm(permission, this.siteService.siteReference(siteId));
    }

    private List<String> getUserIdsWithPermission(String permission, String siteId, String groupId) {
        return this.getUserIdsWithPermissionOnRealm(permission, this.siteService.siteGroupReference(siteId, groupId));
    }

    private List<String> getUserIdsWithPermissionOnRealm(String permission, String realmId) {
        ArrayList<String> rv = new ArrayList<String>();
        for (User user : this.securityService.unlockUsers(permission, realmId)) {
            rv.add(user.getId());
        }
        return rv;
    }

    public SignupUser getSignupUser(SignupMeeting meeting, String userId) {
        SignupUser signupUser = null;
        List signupSites = meeting.getSignupSites();
        SignupSite currentSignupSite = null;
        for (SignupSite signupSite : signupSites) {
            Member member;
            Site site = null;
            try {
                site = this.siteService.getSite(signupSite.getSiteId());
            }
            catch (IdUnusedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (site == null) continue;
            if (site.getId().equals(signupSite.getSiteId())) {
                currentSignupSite = signupSite;
            }
            if ((member = site.getMember(userId)) == null || !member.isActive() || !this.hasPermissionToAttend(signupSite, userId)) continue;
            User user = this.getUser(member.getUserId());
            if (user != null) {
                SignupUser sUser = new SignupUser(member.getUserEid(), member.getUserId(), "", member.getUserEid(), member.getRole(), site.getId(), site.isPublished());
                if (signupUser == null) {
                    signupUser = sUser;
                    continue;
                }
                if (sUser.isPublishedSite() && sUser.getMainSiteId().equals(this.getCurrentLocationId())) {
                    return sUser;
                }
                if (signupUser.isPublishedSite() || !sUser.isPublishedSite()) continue;
                signupUser = sUser;
                continue;
            }
            log.info("user is not found from 'userDirectoryService' for userId:" + member.getUserId());
        }
        if (signupUser == null) {
            signupUser = this.getSignupUserForLoginRequiredOnlySite(currentSignupSite, userId);
        }
        return signupUser;
    }

    public List<User> getUsersWithPermission(String permission) {
        try {
            Site currentSite = this.siteService.getSite(this.getCurrentLocationId());
            Set usersWithPermission = this.authzGroupService.getUsersIsAllowed(permission, Collections.singletonList(currentSite.getReference()));
            return this.userDirectoryService.getUsers((Collection)usersWithPermission);
        }
        catch (Exception e) {
            log.error("getUsersWithPermission exception: " + e.getClass() + ":" + e.getMessage());
            return Collections.EMPTY_LIST;
        }
    }

    private boolean hasPermissionToAttend(SignupSite site, String userId) {
        if (this.isAllowedSite(userId, "signup.attend.all", site.getSiteId())) {
            return true;
        }
        if (site.isSiteScope()) {
            if (this.isAllowedSite(userId, "signup.attend", site.getSiteId())) {
                return true;
            }
        } else {
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                if (!this.isAllowedGroup(userId, "signup.attend", site.getSiteId(), group.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPermissionToCreate(SignupMeeting meeting, String userId) {
        List signupSites = meeting.getSignupSites();
        if (signupSites != null) {
            for (SignupSite site : signupSites) {
                if (this.isAllowedSite(userId, "signup.create.site", site.getSiteId())) {
                    return true;
                }
                if (site.isSiteScope()) {
                    if (!this.isAllowedSite(userId, "signup.create.site", site.getSiteId())) continue;
                    return true;
                }
                List signupGroups = site.getSignupGroups();
                for (SignupGroup group : signupGroups) {
                    if (!this.isAllowedGroup(userId, "signup.create.group.all", site.getSiteId(), group.getGroupId()) && !this.isAllowedGroup(userId, "signup.create.group", site.getSiteId(), group.getGroupId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private SignupUser getSignupUserForLoginRequiredOnlySite(SignupSite signupSite, String userId) {
        SignupUser signupUser = null;
        Site site = null;
        try {
            site = this.siteService.getSite(signupSite.getSiteId());
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (site == null) {
            return null;
        }
        Set siteRoles = site.getRoles();
        if (siteRoles != null) {
            for (Role role : siteRoles) {
                if (!".auth".equals(role.getId()) || !this.hasPermissionToAttend(signupSite, userId)) continue;
                User user = this.getUser(userId);
                if (user == null) break;
                signupUser = new SignupUser(user.getEid(), userId, user.getFirstName(), user.getLastName(), role, site.getId(), site.isPublished());
                break;
            }
        }
        return signupUser;
    }

    private void getUsersForGroup(Set<SignupUser> signupUsers, SignupSite signupSite, SignupGroup signupGroup) {
        Site site = null;
        try {
            site = this.siteService.getSite(signupSite.getSiteId());
        }
        catch (IdUnusedException e) {
            log.error("Cannot get the info about siteId: " + e.getMessage());
            return;
        }
        Group group = site.getGroup(signupGroup.getGroupId());
        if (group == null) {
            return;
        }
        Set members = group.getMembers();
        ArrayList<String> userIds = new ArrayList<String>();
        Hashtable<String, Role> memberRoleMap = new Hashtable<String, Role>();
        for (Member member : members) {
            if (!member.isActive() || !this.hasPredefinedViewPermisson(member) && !this.isAllowedGroup(member.getUserId(), "signup.view", site.getId(), group.getId()) && !this.isAllowedSite(member.getUserId(), "signup.view.all", site.getId())) continue;
            memberRoleMap.put(member.getUserId(), member.getRole());
            userIds.add(member.getUserId());
        }
        this.addAndPopulateSignupUsersInfo(signupUsers, memberRoleMap, userIds, site);
    }

    private void addAndPopulateSignupUsersInfo(Set<SignupUser> signupUsers, Map<String, Role> memberRoleMap, List<String> userIds, Site site) {
        List sakaiUsers = this.userDirectoryService.getUsers(userIds);
        if (sakaiUsers != null) {
            for (User user : sakaiUsers) {
                SignupUser signupUser = new SignupUser(user.getEid(), user.getId(), user.getFirstName(), user.getLastName(), memberRoleMap.get(user.getId()), site.getId(), site.isPublished());
                this.processAddOrUpdateSignupUsers(signupUsers, signupUser);
            }
        }
    }

    private void getAttendeesForGroup(Set<SignupUser> signupUsers, SignupSite signupSite, SignupGroup signupGroup) {
        Site site = null;
        try {
            site = this.siteService.getSite(signupSite.getSiteId());
        }
        catch (IdUnusedException e) {
            log.error("Cannot get the info about siteId: " + e.getMessage());
            return;
        }
        Group group = site.getGroup(signupGroup.getGroupId());
        if (group == null) {
            return;
        }
        Set members = group.getMembers();
        ArrayList<String> userIds = new ArrayList<String>();
        Hashtable<String, Role> memberRoleMap = new Hashtable<String, Role>();
        for (Member member : members) {
            if (!member.isActive() || !this.hasPredefinedViewPermisson(member) && !this.isAllowedGroup(member.getUserId(), "signup.attend", site.getId(), group.getId()) && !this.isAllowedSite(member.getUserId(), "signup.attend.all", site.getId())) continue;
            memberRoleMap.put(member.getUserId(), member.getRole());
            userIds.add(member.getUserId());
        }
        this.addAndPopulateSignupUsersInfo(signupUsers, memberRoleMap, userIds, site);
    }

    private boolean hasPredefinedViewPermisson(Member member) {
        return "student".equalsIgnoreCase(member.getRole().getId());
    }

    private void getUsersForSiteWithSiteScope(Set<SignupUser> signupUsers, SignupSite signupSite) {
        Site site = null;
        try {
            site = this.siteService.getSite(signupSite.getSiteId());
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (site == null) {
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        Hashtable<String, Role> memberRoleMap = new Hashtable<String, Role>();
        Set members = site.getMembers();
        for (Member member : members) {
            if (!member.isActive() || !this.hasPredefinedViewPermisson(member) && !this.isAllowedSite(member.getUserId(), "signup.view", site.getId()) && !this.isAllowedSite(member.getUserId(), "signup.view.all", site.getId())) continue;
            memberRoleMap.put(member.getUserId(), member.getRole());
            userIds.add(member.getUserId());
        }
        this.addAndPopulateSignupUsersInfo(signupUsers, memberRoleMap, userIds, site);
    }

    private void getAttendeesForSiteWithSiteScope(Set<SignupUser> signupUsers, SignupSite signupSite) {
        Site site = null;
        try {
            site = this.siteService.getSite(signupSite.getSiteId());
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (site == null) {
            return;
        }
        Set members = site.getMembers();
        ArrayList<String> userIds = new ArrayList<String>();
        Hashtable<String, Role> memberRoleMap = new Hashtable<String, Role>();
        for (Member member : members) {
            if (!member.isActive() || !this.hasPredefinedViewPermisson(member) && !this.isAllowedSite(member.getUserId(), "signup.attend", site.getId()) && !this.isAllowedSite(member.getUserId(), "signup.attend.all", site.getId()) && !this.isAllowedSite(member.getUserId(), "signup.update.site", site.getId())) continue;
            memberRoleMap.put(member.getUserId(), member.getRole());
            userIds.add(member.getUserId());
        }
        this.addAndPopulateSignupUsersInfo(signupUsers, memberRoleMap, userIds, site);
    }

    private void processAddOrUpdateSignupUsers(Set<SignupUser> signupUsers, SignupUser signupUser) {
        boolean update = true;
        if (!signupUsers.isEmpty() && signupUsers.contains(signupUser)) {
            for (SignupUser sUser : signupUsers) {
                if (!sUser.getEid().equals(signupUser.getEid())) continue;
                if (!sUser.isPublishedSite() && signupUser.isPublishedSite() || signupUser.isPublishedSite() && signupUser.getMainSiteId().equals(this.getCurrentLocationId())) {
                    update = true;
                    break;
                }
                update = false;
                break;
            }
        }
        if (update) {
            signupUsers.add(signupUser);
        }
    }

    public Calendar getCalendar(String siteId) throws PermissionException {
        String calendarId = this.calendarService.calendarReference(siteId, "main");
        return this.getCalendarById(calendarId);
    }

    public Calendar getCalendarById(String calendarId) throws PermissionException {
        Calendar calendar = null;
        try {
            calendar = this.calendarService.getCalendar(calendarId);
        }
        catch (IdUnusedException e) {
            try {
                CalendarEdit calendarEdit = this.calendarService.addCalendar(calendarId);
                this.calendarService.commitCalendar(calendarEdit);
                calendar = this.getCalendarById(calendarId);
            }
            catch (IdInvalidException highlyUnlikely) {
                log.error(highlyUnlikely.getMessage());
            }
            catch (IdUsedException extremelyUnlikely) {
                log.error(extremelyUnlikely.getMessage());
            }
        }
        return calendar;
    }

    public Group getGroup(String siteId, String groupId) throws IdUnusedException {
        Site site = this.siteService.getSite(siteId);
        return site.getGroup(groupId);
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public ContentHostingService getContentHostingService() {
        return this.contentHostingService;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public List<User> getUsersByEmail(String email) {
        return (List)this.userDirectoryService.findUsersByEmail(email);
    }

    public User getUserByEmail(String email) {
        List users = (List)this.userDirectoryService.findUsersByEmail(email);
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    public User getUserByEid(String eid) {
        try {
            return this.userDirectoryService.getUserByEid(eid);
        }
        catch (UserNotDefinedException e) {
            log.debug("User with eid: " + eid + " does not exist.");
            return null;
        }
    }

    public boolean isCsvExportEnabled() {
        return this.serverConfigurationService.getBoolean("signup.csv.export.enabled", false);
    }

    public SecurityAdvisor pushAllowCalendarEdit(final Calendar calendar) {
        SecurityAdvisor advisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                if (calendar != null && calendar.canModifyAnyEvent(function)) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
                return SecurityAdvisor.SecurityAdvice.NOT_ALLOWED;
            }
        };
        this.enableSecurityAdvisor(advisor);
        return advisor;
    }

    public SecurityAdvisor pushSecurityAdvisor() {
        SecurityAdvisor advisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(advisor);
        return advisor;
    }

    public void popSecurityAdvisor(SecurityAdvisor advisor) {
        this.disableSecurityAdvisor(advisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createGroup(String siteId, String title, String description, List<String> userUuids) {
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (Exception e) {
            log.error("createGroup failed for site: " + site.getId(), (Throwable)e);
            return null;
        }
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(securityAdvisor);
        try {
            Group group = site.addGroup();
            group.setTitle("SIGNUP_" + title);
            group.setDescription(description);
            group.getProperties().addProperty("group_prop_wsetup_created", Boolean.TRUE.toString());
            if (userUuids != null) {
                group.removeMembers();
                for (String userUuid : userUuids) {
                    group = this.addUserToGroup(userUuid, group);
                }
            }
            this.siteService.save(site);
            String string = group.getId();
            return string;
        }
        catch (Exception e) {
            log.error("createGroup failed for site: " + site.getId(), (Throwable)e);
        }
        finally {
            this.disableSecurityAdvisor(securityAdvisor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUsersToGroup(Collection<String> userIds, String siteId, String groupId, String timeslottoGroup) {
        log.debug("addUsersToGroup(userIds=" + Arrays.asList(userIds).toString() + ", siteId=" + siteId + ", groupId=" + groupId);
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (Exception e) {
            log.error("addUserToGroup failed to retrieve site: " + siteId, (Throwable)e);
            return false;
        }
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(securityAdvisor);
        Group group = site.getGroup(groupId);
        if (group == null) {
            log.error("No group for id: " + groupId);
            return false;
        }
        try {
            for (String userId : userIds) {
                group = this.addUserToGroup(userId, group);
            }
            if (timeslottoGroup.equals("toGroup")) {
                List<String> updateusers = this.getGroupMembers(siteId, groupId);
                HashSet<String> tmpUsers = new HashSet<String>();
                tmpUsers.addAll(updateusers);
                tmpUsers.removeAll(userIds);
                for (String mem : tmpUsers) {
                    group.removeMember(mem);
                }
            }
            this.siteService.save(site);
            boolean updateusers = true;
            return updateusers;
        }
        catch (Exception e) {
            log.error("addUsersToGroup failed for users: " + Arrays.asList(userIds).toString() + " and group: " + groupId, (Throwable)e);
        }
        finally {
            this.disableSecurityAdvisor(securityAdvisor);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchonizeGroupTitle(String siteId, String groupId, String newTitle) {
        Site site = null;
        boolean changed = false;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (Exception e) {
            log.error("synchronizeGroup failed to retrieve site: " + siteId, (Throwable)e);
            return false;
        }
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(securityAdvisor);
        Group group = site.getGroup(groupId);
        if (group == null) {
            log.error("No group for id: " + groupId);
            return false;
        }
        try {
            if (group.getTitle().startsWith("SIGNUP_")) {
                group.setTitle("SIGNUP_" + newTitle);
                this.siteService.save(site);
                changed = true;
            } else if (group.getTitle().contains(newTitle)) {
                changed = true;
            }
        }
        catch (Exception e) {
            log.error("synchGroupTitle failed for group: " + group.getTitle() + " and group: " + groupId, (Throwable)e);
        }
        finally {
            this.disableSecurityAdvisor(securityAdvisor);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserFromGroup(String userId, String siteId, String groupId) {
        log.debug("removeUserFromGroup(userId=" + userId + ", siteId=" + siteId + ", groupId=" + groupId);
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (Exception e) {
            log.error("removeUserFromGroup failed to retrieve site: " + siteId, (Throwable)e);
            return false;
        }
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(securityAdvisor);
        Group group = site.getGroup(groupId);
        try {
            group.removeMember(userId);
            this.siteService.save(site);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("removeUserFromGroup failed for user: " + userId + " and group: " + groupId, (Throwable)e);
        }
        finally {
            this.disableSecurityAdvisor(securityAdvisor);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupMembers(String siteId, String groupId) {
        ArrayList<String> users = new ArrayList<String>();
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (Exception e) {
            log.error("getGroupMembers failed to retrieve site: " + siteId, (Throwable)e);
            return users;
        }
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(securityAdvisor);
        try {
            Group group = site.getGroup(groupId);
            Set members = group.getMembers();
            for (Member m : members) {
                users.add(m.getUserId());
                log.warn("Added user: " + m.getUserId() + " to group: " + groupId);
            }
            ArrayList<String> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            log.error("getGroupMembers failed for site: " + siteId + " and group: " + groupId, (Throwable)e);
        }
        finally {
            this.disableSecurityAdvisor(securityAdvisor);
        }
        return users;
    }

    public boolean checkForGroup(String siteId, String groupId) {
        log.debug("checkForGroup: siteId=" + siteId + ", groupId=" + groupId);
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (Exception e) {
            log.error("checkForGroup failed to retrieve site: " + siteId, (Throwable)e);
            return false;
        }
        Group group = site.getGroup(groupId);
        return group != null;
    }

    private Group addUserToGroup(String userUuid, Group group) {
        Role memberRole;
        Site site = group.getContainingSite();
        Role r = site.getUserRole(userUuid);
        Member m = site.getMember(userUuid);
        Role role = memberRole = m != null ? m.getRole() : null;
        group.addMember(userUuid, r != null ? r.getId() : (memberRole != null ? memberRole.getId() : ""), m != null ? m.isActive() : true, false);
        return group;
    }

    private void enableSecurityAdvisor(SecurityAdvisor securityAdvisor) {
        this.securityService.pushAdvisor(securityAdvisor);
    }

    private void disableSecurityAdvisor(SecurityAdvisor securityAdvisor) {
        this.securityService.popAdvisor(securityAdvisor);
    }
}

